/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.saga.repository;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Filters;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class SagaEntry<T> {
    private static final String SAGA_IDENTIFIER = "sagaIdentifier";
    private static final String SERIALIZED_SAGA = "serializedSaga";
    private static final String SAGA_TYPE = "sagaType";
    private static final String ASSOCIATIONS = "associations";
    private static final String ASSOCIATION_KEY = "key";
    private static final String ASSOCIATION_VALUE = "value";
    private final String sagaId;
    private final String sagaType;
    private final byte[] serializedSaga;
    private final AtomicReference<T> saga = new AtomicReference();
    private final Set<AssociationValue> associationValues;

    public SagaEntry(String identifier, T saga, Set<AssociationValue> associationValues, Serializer serializer) {
        this.sagaId = identifier;
        SerializedObject serialized = serializer.serialize(saga, byte[].class);
        this.serializedSaga = (byte[])serialized.getData();
        this.sagaType = serializer.typeForClass(saga.getClass()).getName();
        this.saga.set(saga);
        this.associationValues = new HashSet<AssociationValue>(associationValues);
    }

    public SagaEntry(Document dbSaga) {
        this.sagaId = (String)dbSaga.get((Object)SAGA_IDENTIFIER);
        this.serializedSaga = ((Binary)dbSaga.get((Object)SERIALIZED_SAGA)).getData();
        this.sagaType = (String)dbSaga.get((Object)SAGA_TYPE);
        this.associationValues = this.toAssociationSet(dbSaga);
    }

    public T getSaga(Serializer serializer) {
        return this.saga.updateAndGet(current -> {
            if (current != null) {
                return current;
            }
            return serializer.deserialize((SerializedObject)new SimpleSerializedObject((Object)this.serializedSaga, byte[].class, this.sagaType, ""));
        });
    }

    public String getSagaId() {
        return this.sagaId;
    }

    public Set<AssociationValue> getAssociationValues() {
        return this.associationValues;
    }

    public Document asDocument() {
        return new Document(SAGA_TYPE, (Object)this.sagaType).append(SAGA_IDENTIFIER, (Object)this.sagaId).append(SERIALIZED_SAGA, (Object)this.serializedSaga).append(ASSOCIATIONS, SagaEntry.toDBList(this.associationValues));
    }

    private Set<AssociationValue> toAssociationSet(Document dbSaga) {
        HashSet<AssociationValue> values = new HashSet<AssociationValue>();
        List list = (List)dbSaga.get((Object)ASSOCIATIONS);
        if (list != null) {
            values.addAll(list.stream().map(item -> new AssociationValue((String)item.get((Object)ASSOCIATION_KEY), (String)item.get((Object)ASSOCIATION_VALUE))).collect(Collectors.toList()));
        }
        return values;
    }

    private static List<Object> toDBList(Iterable<AssociationValue> associationValues) {
        BasicDBList list = new BasicDBList();
        for (AssociationValue associationValue : associationValues) {
            list.add((Object)new BasicDBObject(ASSOCIATION_KEY, (Object)associationValue.getKey()).append(ASSOCIATION_VALUE, (Object)associationValue.getValue()));
        }
        return list;
    }

    public static Bson queryByIdentifier(String identifier) {
        return Filters.eq((String)SAGA_IDENTIFIER, (Object)identifier);
    }
}

