/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.saga.repository;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.extensions.mongo.eventhandling.saga.repository.SagaEntry;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSagaStore
implements SagaStore<Object> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MongoTemplate mongoTemplate;
    private final Serializer serializer;

    protected MongoSagaStore(Builder builder) {
        builder.validate();
        this.mongoTemplate = builder.mongoTemplate;
        this.serializer = (Serializer)builder.serializer.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        Document dbSaga = (Document)this.mongoTemplate.sagaCollection().find(SagaEntry.queryByIdentifier(sagaIdentifier)).first();
        if (dbSaga == null) {
            return null;
        }
        final SagaEntry sagaEntry = new SagaEntry(dbSaga);
        final Object loadedSaga = sagaEntry.getSaga(this.serializer);
        return new SagaStore.Entry<S>(){

            public Set<AssociationValue> associationValues() {
                return sagaEntry.getAssociationValues();
            }

            public S saga() {
                return loadedSaga;
            }
        };
    }

    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        BasicDBObject value = this.associationValueQuery(sagaType, associationValue);
        MongoCursor dbCursor = this.mongoTemplate.sagaCollection().find((Bson)value).projection(Projections.include((String[])new String[]{"sagaIdentifier"})).iterator();
        TreeSet<String> found = new TreeSet<String>();
        while (dbCursor.hasNext()) {
            found.add((String)((Document)dbCursor.next()).get((Object)"sagaIdentifier"));
        }
        return found;
    }

    private BasicDBObject associationValueQuery(Class<?> sagaType, AssociationValue associationValue) {
        BasicDBObject value = new BasicDBObject();
        value.put((Object)"sagaType", (Object)this.getSagaTypeName(sagaType));
        BasicDBObject dbAssociation = new BasicDBObject();
        dbAssociation.put((Object)"key", (Object)associationValue.getKey());
        dbAssociation.put((Object)"value", (Object)associationValue.getValue());
        value.put((Object)"associations", (Object)dbAssociation);
        return value;
    }

    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        this.mongoTemplate.sagaCollection().findOneAndDelete(SagaEntry.queryByIdentifier(sagaIdentifier));
    }

    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, AssociationValues associationValues) {
        SagaEntry<Object> sagaEntry = new SagaEntry<Object>(sagaIdentifier, saga, associationValues.asSet(), this.serializer);
        this.mongoTemplate.sagaCollection().updateOne(SagaEntry.queryByIdentifier(sagaIdentifier), (Bson)new Document("$set", (Object)sagaEntry.asDocument()));
    }

    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, Set<AssociationValue> associationValues) {
        SagaEntry<Object> sagaEntry = new SagaEntry<Object>(sagaIdentifier, saga, associationValues, this.serializer);
        Document sagaObject = sagaEntry.asDocument();
        this.mongoTemplate.sagaCollection().insertOne((Object)sagaObject);
    }

    private String getSagaTypeName(Class<?> sagaType) {
        return this.serializer.typeForClass(sagaType).getName();
    }

    public static class Builder {
        private MongoTemplate mongoTemplate;
        private Supplier<Serializer> serializer;

        public Builder mongoTemplate(MongoTemplate mongoTemplate) {
            BuilderUtils.assertNonNull((Object)mongoTemplate, (String)"MongoTemplate may not be null");
            this.mongoTemplate = mongoTemplate;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = () -> serializer;
            return this;
        }

        public MongoSagaStore build() {
            return new MongoSagaStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.mongoTemplate, (String)"The MongoTemplate is a hard requirement and should be provided");
            if (this.serializer == null) {
                logger.warn("The default XStreamSerializer is used, whereas it is strongly recommended to configure the security context of the XStream instance.", (Throwable)new AxonConfigurationException("A default XStreamSerializer is used, without specifying the security context"));
                this.serializer = XStreamSerializer::defaultSerializer;
            }
        }
    }
}

