/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.update.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.axonframework.common.annotation.Internal;
import org.axonframework.update.configuration.DefaultUsagePropertyProvider;
import org.axonframework.update.configuration.UsagePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PropertyFileUsagePropertyProvider
implements UsagePropertyProvider {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileUsagePropertyProvider.class);
    private static final String AXONIQ_PROPERTIES_PATH = "/.axoniq/update-checker.properties";
    private static final String TELEMETRY_URL_FIELD_NAME = "telemetry_url";
    private static final String DISABLED_PROPERTY_NAME = "disabled";
    private Boolean disabled;
    private String telemetryEndpoint;
    private boolean loaded = false;

    @Override
    public Boolean getDisabled() {
        this.ensureLoaded();
        return this.disabled;
    }

    @Override
    public String getUrl() {
        this.ensureLoaded();
        return this.telemetryEndpoint;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
    }

    private void load() {
        try {
            File installationIdFile = this.getFile();
            if (installationIdFile == null) {
                logger.debug("Could not determine user home directory. Skipping property provider from file.");
                return;
            }
            Properties properties = new Properties();
            if (!installationIdFile.exists()) {
                this.createDefaultFile();
            }
            try (InputStream in = Files.newInputStream(installationIdFile.toPath(), new OpenOption[0]);){
                properties.load(in);
            }
            this.telemetryEndpoint = properties.getProperty(TELEMETRY_URL_FIELD_NAME);
            this.disabled = Boolean.valueOf(properties.getProperty(DISABLED_PROPERTY_NAME));
        }
        catch (Exception e) {
            logger.debug("Failed to load AxonIQ properties from file: {}. Skipping property provider from file.", (Object)(this.getFile() != null ? this.getFile().getAbsolutePath() : "unknown"), (Object)e);
        }
    }

    @Override
    public int priority() {
        return 0;
    }

    private void createDefaultFile() throws IOException {
        File file = this.getFile();
        if (file == null) {
            logger.debug("Could not determine user home directory. Skipping creation of default properties file.");
            return;
        }
        logger.info("Creating default AxonIQ Data Collection properties file at: {}", (Object)file.getAbsolutePath());
        Properties properties = new Properties();
        properties.setProperty(TELEMETRY_URL_FIELD_NAME, DefaultUsagePropertyProvider.INSTANCE.getUrl());
        properties.setProperty(DISABLED_PROPERTY_NAME, String.valueOf(DefaultUsagePropertyProvider.INSTANCE.getDisabled()));
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
        }
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            properties.store(out, "AxonIQ Anonymous Usage Reporting");
        }
    }

    private File getFile() {
        String pwdDir = System.getProperty("user.home");
        if (pwdDir == null) {
            return null;
        }
        String installationIdFilePath = pwdDir + AXONIQ_PROPERTIES_PATH;
        return new File(installationIdFilePath);
    }
}

