/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.update.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.update.configuration.UsagePropertyProvider;

@Internal
public class EnvironmentVariableUsagePropertyProvider
implements UsagePropertyProvider {
    public static final String DISABLED_KEY = "AXONIQ_UPDATE_CHECKER_DISABLED";
    public static final String URL_KEY = "AXONIQ_UPDATE_CHECKER_URL";
    private final EnvironmentVariableSupplier envSupplier;

    public EnvironmentVariableUsagePropertyProvider() {
        this(System::getenv);
    }

    public EnvironmentVariableUsagePropertyProvider(@Nonnull EnvironmentVariableSupplier envSupplier) {
        this.envSupplier = Objects.requireNonNull(envSupplier, "The envSupplier must not be null.");
    }

    @Override
    public Boolean getDisabled() {
        String property = this.envSupplier.get(DISABLED_KEY);
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return null;
    }

    @Override
    public String getUrl() {
        return this.envSupplier.get(URL_KEY);
    }

    @Override
    public int priority() {
        return 0x3FFFFFFF;
    }

    @FunctionalInterface
    public static interface EnvironmentVariableSupplier {
        public String get(String var1);
    }
}

