/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.ConcurrentHashMap;

public final class ClassUtils {
    private static ClassLoader classLoader = ClassUtils.class.getClassLoader();
    private static ConcurrentHashMap<String, Class<?>> cache = new ConcurrentHashMap();

    private ClassUtils() {
    }

    public static <C> Class<C> loadClass(String className) {
        return cache.computeIfAbsent(className, name -> {
            try {
                return classLoader.loadClass((String)name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load class " + name, e);
            }
        });
    }
}

