/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.eventhandling.EventMessage;

public interface AxonTestPhase {

    public static interface Then {

        public static interface MessageAssertions<T extends MessageAssertions<T>> {
            public T events(Object ... var1);

            public T events(EventMessage ... var1);

            public T eventsSatisfy(@Nonnull Consumer<List<EventMessage>> var1);

            public T eventsMatch(@Nonnull Predicate<List<EventMessage>> var1);

            default public T noEvents() {
                return this.events(new EventMessage[0]);
            }

            public T commands(Object ... var1);

            public T commands(CommandMessage ... var1);

            public T commandsSatisfy(@Nonnull Consumer<List<CommandMessage>> var1);

            public T commandsMatch(@Nonnull Predicate<List<CommandMessage>> var1);

            public T noCommands();

            public T exception(@Nonnull Class<? extends Throwable> var1);

            public T exception(@Nonnull Class<? extends Throwable> var1, @Nonnull String var2);

            public T exceptionSatisfies(@Nonnull Consumer<Throwable> var1);

            public T expect(@Nonnull Consumer<Configuration> var1);

            public T expectAsync(@Nonnull Function<Configuration, CompletableFuture<?>> var1);
        }

        public static interface Message<T extends Message<T>>
        extends MessageAssertions<T> {
            default public T await(@Nonnull Consumer<T> assertion) {
                return this.await(assertion, Duration.ofSeconds(5L));
            }

            public T await(@Nonnull Consumer<T> var1, @Nonnull Duration var2);

            public Setup and();

            default public void stop() {
                this.and().stop();
            }
        }

        public static interface Nothing
        extends Message<Nothing> {
        }

        public static interface Event
        extends Message<Event> {
            public Event success();
        }

        public static interface Command
        extends Message<Command> {
            public Command success();

            public Command resultMessageSatisfies(@Nonnull Consumer<? super CommandResultMessage> var1);

            public Command resultMessagePayload(@Nonnull Object var1);

            public Command resultMessagePayloadSatisfies(@Nonnull Consumer<Object> var1);
        }
    }

    public static interface When {
        default public Command command(@Nonnull Object payload) {
            return this.command(payload, new HashMap<String, String>());
        }

        default public Command command(@Nonnull Object payload, @Nonnull Map<String, String> metadata) {
            return this.command(payload, Metadata.from(metadata));
        }

        public Command command(@Nonnull Object var1, @Nonnull Metadata var2);

        default public Event event(@Nonnull Object payload) {
            return this.event(payload, Metadata.emptyInstance());
        }

        default public Event event(@Nonnull Object payload, @Nonnull Map<String, String> metadata) {
            return this.event(payload, Metadata.from(metadata));
        }

        public Event event(@Nonnull Object var1, @Nonnull Metadata var2);

        public Event events(EventMessage ... var1);

        default public Event events(Object ... events) {
            return this.events(Arrays.stream(events).toList());
        }

        public Event events(@Nonnull List<?> var1);

        public Nothing nothing();

        public static interface Command {
            public Then.Command then();
        }

        public static interface Event {
            public Then.Event then();
        }

        public static interface Nothing {
            public Then.Nothing then();
        }
    }

    public static interface Given {
        public Given noPriorActivity();

        default public Given event(@Nonnull Object payload) {
            return this.event(payload, Metadata.emptyInstance());
        }

        default public Given event(@Nonnull Object payload, @Nonnull Map<String, String> metadata) {
            return this.event(payload, Metadata.from(metadata));
        }

        public Given event(@Nonnull Object var1, @Nonnull Metadata var2);

        public Given events(EventMessage ... var1);

        default public Given events(Object ... events) {
            return this.events(Arrays.stream(events).toList());
        }

        public Given events(@Nonnull List<?> var1);

        default public Given command(@Nonnull Object payload) {
            return this.command(payload, Metadata.emptyInstance());
        }

        default public Given command(@Nonnull Object payload, @Nonnull Map<String, String> metadata) {
            return this.command(payload, Metadata.from(metadata));
        }

        public Given command(@Nonnull Object var1, @Nonnull Metadata var2);

        public Given commands(CommandMessage ... var1);

        default public Given commands(Object ... commands) {
            return this.commands(Arrays.stream(commands).toList());
        }

        public Given commands(@Nonnull List<?> var1);

        public Given execute(@Nonnull Function<Configuration, ?> var1);

        public Given executeAsync(@Nonnull Function<Configuration, CompletableFuture<?>> var1);

        public When when();

        public Then.Nothing then();
    }

    public static interface Setup {
        public Given given();

        public When when();

        public void stop();
    }
}

