/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.GenericCommandResultMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.test.util.CallbackBehavior;
import org.axonframework.test.util.DefaultCallbackBehavior;

@Internal
public class RecordingCommandBus
implements CommandBus {
    private final ConcurrentMap<QualifiedName, CommandHandler> subscriptions = new ConcurrentHashMap<QualifiedName, CommandHandler>();
    private final List<CommandMessage> dispatchedCommands = new ArrayList<CommandMessage>();
    private CallbackBehavior callbackBehavior = new DefaultCallbackBehavior();

    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        this.dispatchedCommands.add(command);
        try {
            return CompletableFuture.completedFuture(RecordingCommandBus.asCommandResultMessage(this.callbackBehavior.handle(command.payload(), command.metadata())));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler handler) {
        CommandHandler commandHandler = Objects.requireNonNull(handler, "Given handler cannot be null.");
        this.subscriptions.putIfAbsent(name, commandHandler);
        return this;
    }

    private static CommandResultMessage asCommandResultMessage(@Nullable Object commandResult) {
        if (commandResult instanceof CommandResultMessage) {
            return (CommandResultMessage)commandResult;
        }
        if (commandResult instanceof Message) {
            Message commandResultMessage = (Message)commandResult;
            return new GenericCommandResultMessage(commandResultMessage);
        }
        MessageType type = new MessageType(ObjectUtils.nullSafeTypeOf((Object)commandResult));
        return new GenericCommandResultMessage(type, commandResult);
    }

    public void clearCommands() {
        this.dispatchedCommands.clear();
    }

    public void clearSubscriptions() {
        this.subscriptions.clear();
    }

    public boolean isSubscribed(CommandHandler commandHandler) {
        return this.subscriptions.containsValue(commandHandler);
    }

    public boolean isSubscribed(QualifiedName commandName, CommandHandler commandHandler) {
        return this.subscriptions.containsKey(commandName) && ((CommandHandler)this.subscriptions.get(commandName)).equals((Object)commandHandler);
    }

    public Map<QualifiedName, CommandHandler> getSubscriptions() {
        return this.subscriptions;
    }

    public List<CommandMessage> getDispatchedCommands() {
        return this.dispatchedCommands;
    }

    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.callbackBehavior = callbackBehavior;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("subscriptions", this.subscriptions);
        descriptor.describeProperty("dispatchedCommands", this.dispatchedCommands);
        descriptor.describeProperty("callbackBehavior", (Object)this.callbackBehavior);
    }
}

