/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.CommandValidator;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;
import org.axonframework.test.fixture.Reporter;
import org.axonframework.test.matchers.MapStringEntryMatcher;
import org.axonframework.test.matchers.MatchAllFieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.hamcrest.Matcher;

abstract class AxonTestThenMessage<T extends AxonTestPhase.Then.Message<T>>
implements AxonTestPhase.Then.Message<T> {
    protected final Reporter reporter = new Reporter();
    private final AxonConfiguration configuration;
    private final AxonTestFixture.Customization customization;
    private final RecordingEventSink eventSink;
    private final RecordingCommandBus commandBus;
    private final CommandValidator commandValidator;
    protected final Throwable actualException;

    public AxonTestThenMessage(@Nonnull AxonConfiguration configuration, @Nonnull AxonTestFixture.Customization customization, @Nonnull RecordingCommandBus commandBus, @Nonnull RecordingEventSink eventSink, @Nullable Throwable actualException) {
        this.configuration = configuration;
        this.customization = customization;
        this.commandBus = commandBus;
        this.eventSink = eventSink;
        this.actualException = actualException;
        this.commandValidator = new CommandValidator(commandBus::recordedCommands, commandBus::reset, new MatchAllFieldFilter(customization.fieldFilters()));
    }

    @Override
    public T events(Object ... expectedEvents) {
        List<EventMessage> publishedEvents = this.eventSink.recorded();
        if (expectedEvents.length != publishedEvents.size()) {
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage> iterator = publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage actualEvent = iterator.next();
            if (this.verifyPayloadEquality(expectedEvent, actualEvent.payload())) continue;
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this.self();
    }

    @Override
    public T events(EventMessage ... expectedEvents) {
        this.events(Stream.of(expectedEvents).map(Message::payload).toArray());
        List<EventMessage> publishedEvents = this.eventSink.recorded();
        Iterator<EventMessage> iterator = publishedEvents.iterator();
        for (EventMessage expectedEvent : expectedEvents) {
            EventMessage actualEvent = iterator.next();
            if (this.verifyMetadataEquality(expectedEvent.payloadType(), (Map<String, String>)expectedEvent.metadata(), (Map<String, String>)actualEvent.metadata())) continue;
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this.self();
    }

    @Override
    public T eventsSatisfy(@Nonnull Consumer<List<EventMessage>> consumer) {
        Objects.requireNonNull(consumer, "The consumer may not be null.");
        List<EventMessage> publishedEvents = this.eventSink.recorded();
        try {
            consumer.accept(publishedEvents);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Events does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T eventsMatch(@Nonnull Predicate<List<EventMessage>> predicate) {
        Objects.requireNonNull(predicate, "The predicate may not be null.");
        List<EventMessage> publishedEvents = this.eventSink.recorded();
        boolean result = predicate.test(publishedEvents);
        if (!result) {
            throw new AxonAssertionError("Events does not satisfy the predicate");
        }
        return this.self();
    }

    @Override
    public T commands(Object ... expectedCommands) {
        this.commandValidator.assertDispatchedEqualTo(expectedCommands);
        return this.self();
    }

    @Override
    public T await(@Nonnull Consumer<T> assertion, @Nonnull Duration timeout) {
        Objects.requireNonNull(assertion, "The assertion may not be null.");
        Objects.requireNonNull(timeout, "The timeout may not be null.");
        Awaitility.waitAtMost((Duration)timeout).pollInterval(Duration.ofMillis(50L)).untilAsserted(() -> assertion.accept(this.self()));
        return this.self();
    }

    @Override
    public T commands(CommandMessage ... expectedCommands) {
        this.commandValidator.assertDispatchedEqualTo(List.of(expectedCommands));
        return this.self();
    }

    @Override
    public T commandsSatisfy(@Nonnull Consumer<List<CommandMessage>> consumer) {
        Objects.requireNonNull(consumer, "The consumer may not be null.");
        List<CommandMessage> dispatchedCommands = this.commandBus.recordedCommands();
        try {
            consumer.accept(dispatchedCommands);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Commands does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T commandsMatch(@Nonnull Predicate<List<CommandMessage>> predicate) {
        Objects.requireNonNull(predicate, "The predicate may not be null.");
        List<CommandMessage> dispatchedCommands = this.commandBus.recordedCommands();
        boolean result = predicate.test(dispatchedCommands);
        if (!result) {
            throw new AxonAssertionError("Events does not satisfy the predicate");
        }
        return this.self();
    }

    @Override
    public T noCommands() {
        this.commandValidator.assertDispatchedMatching(Matchers.noCommands());
        return this.self();
    }

    @Override
    public T exceptionSatisfies(@Nonnull Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer, "The consumer may not be null.");
        try {
            consumer.accept(this.actualException);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Exception does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T exception(@Nonnull Class<? extends Throwable> type, @Nonnull String message) {
        Objects.requireNonNull(type, "The type may not be null.");
        Objects.requireNonNull(message, "The message may not be null.");
        if (this.actualException == null) {
            throw new AxonAssertionError("Expected exception of type " + String.valueOf(type) + " with message '" + message + "' but got none");
        }
        if (!type.isInstance(this.actualException) || !message.equals(this.actualException.getMessage())) {
            throw new AxonAssertionError("Expected " + String.valueOf(type) + " with message '" + message + "' but got " + String.valueOf(this.actualException));
        }
        return this.self();
    }

    @Override
    public T exception(@Nonnull Class<? extends Throwable> type) {
        Objects.requireNonNull(type, "The type may not be null.");
        if (this.actualException == null) {
            throw new AxonAssertionError("Expected exception of type " + String.valueOf(type) + " but got none");
        }
        if (!type.isInstance(this.actualException)) {
            throw new AxonAssertionError("Expected " + String.valueOf(type) + " but got " + String.valueOf(this.actualException));
        }
        return this.self();
    }

    protected boolean verifyPayloadEquality(Object expectedPayload, Object actualPayload) {
        if (Objects.equals(expectedPayload, actualPayload)) {
            return true;
        }
        if (expectedPayload != null && actualPayload == null) {
            return false;
        }
        if (expectedPayload == null) {
            return false;
        }
        if (!expectedPayload.getClass().equals(actualPayload.getClass())) {
            return false;
        }
        Matcher<Object> matcher = Matchers.deepEquals(expectedPayload, new MatchAllFieldFilter(this.customization.fieldFilters()));
        if (!matcher.matches(actualPayload)) {
            this.reporter.reportDifferentPayloads(expectedPayload.getClass(), actualPayload, expectedPayload);
        }
        return true;
    }

    protected boolean verifyMetadataEquality(Class<?> eventType, Map<String, String> expectedMetadata, Map<String, String> actualMetadata) {
        MapStringEntryMatcher matcher = new MapStringEntryMatcher(expectedMetadata);
        if (!matcher.matches(actualMetadata)) {
            this.reporter.reportDifferentMetadata(eventType, matcher.getMissingEntries(), matcher.getAdditionalEntries());
        }
        return true;
    }

    @Override
    public AxonTestPhase.Setup and() {
        return new AxonTestFixture(this.configuration, this.customization);
    }

    @Override
    public T expect(@Nonnull Consumer<Configuration> function) {
        Objects.requireNonNull(function, "The function may not be null.");
        function.accept((Configuration)this.configuration);
        return this.self();
    }

    @Override
    public T expectAsync(@Nonnull Function<Configuration, CompletableFuture<?>> function) {
        Objects.requireNonNull(function, "The function may not be null.");
        function.apply((Configuration)this.configuration).join();
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

