/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.annotation.Internal;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class RecordingEventSink
implements EventSink {
    protected final EventSink delegate;
    private final List<EventMessage> recorded;

    public RecordingEventSink(@Nonnull EventSink delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate EventSink may not be null");
        this.recorded = new ArrayList<EventMessage>();
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.delegate.publish(context, events).thenRun(() -> this.recorded.addAll(events));
    }

    public List<EventMessage> recorded() {
        return List.copyOf(this.recorded);
    }

    public RecordingEventSink reset() {
        this.recorded.clear();
        return this;
    }
}

