/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestThenCommand;
import org.axonframework.test.fixture.AxonTestThenEvent;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;

class AxonTestWhen
implements AxonTestPhase.When {
    private final Configuration configuration;
    private final AxonTestFixture.Customization customization;
    private final MessageTypeResolver messageTypeResolver;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private Message actualResult;
    private Throwable actualException;

    public AxonTestWhen(Configuration configuration, AxonTestFixture.Customization customization, MessageTypeResolver messageTypeResolver, RecordingCommandBus commandBus, RecordingEventSink eventSink, UnitOfWorkFactory unitOfWorkFactory) {
        this.configuration = configuration;
        this.customization = customization;
        this.messageTypeResolver = messageTypeResolver;
        this.commandBus = commandBus.reset();
        this.eventSink = eventSink.reset();
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    public Command command(@Nonnull Object payload, @Nonnull MetaData metaData) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        GenericCommandMessage message = new GenericCommandMessage(messageType, payload, (Map)metaData);
        this.inUnitOfWorkOnInvocation(processingContext -> this.commandBus.dispatch((CommandMessage)message, (ProcessingContext)processingContext).whenComplete((r, e) -> {
            if (e == null) {
                this.actualResult = r;
                this.actualException = null;
            } else {
                this.actualResult = null;
                this.actualException = e.getCause();
            }
        }));
        return new Command();
    }

    @Override
    public Event event(@Nonnull Object payload, @Nonnull MetaData metaData) {
        GenericEventMessage eventMessage = this.toGenericEventMessage(payload, metaData);
        return this.events(new EventMessage[]{eventMessage});
    }

    private GenericEventMessage toGenericEventMessage(Object payload, MetaData metaData) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericEventMessage(messageType, payload, (Map)metaData);
    }

    @Override
    public Event events(List<?> ... events) {
        EventMessage[] messages = (EventMessage[])Arrays.stream(events).map(e -> {
            EventMessage message;
            return e instanceof EventMessage ? (message = (EventMessage)e) : this.toGenericEventMessage(e, MetaData.emptyInstance());
        }).toArray(EventMessage[]::new);
        return this.events(messages);
    }

    @Override
    public Event events(EventMessage ... messages) {
        this.inUnitOfWorkOnInvocation(processingContext -> this.eventSink.publish((ProcessingContext)processingContext, messages));
        return new Event();
    }

    private void inUnitOfWorkOnInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        UnitOfWork unitOfWork = this.unitOfWorkFactory.create();
        unitOfWork.onInvocation(action);
        this.awaitCompletion(unitOfWork.execute());
    }

    private void awaitCompletion(CompletableFuture<?> completion) {
        try {
            completion.join();
        }
        catch (Exception e) {
            this.actualResult = null;
            this.actualException = e.getCause();
        }
    }

    class Command
    implements AxonTestPhase.When.Command {
        Command() {
        }

        @Override
        public AxonTestPhase.Then.Command then() {
            return new AxonTestThenCommand(AxonTestWhen.this.configuration, AxonTestWhen.this.customization, AxonTestWhen.this.commandBus, AxonTestWhen.this.eventSink, AxonTestWhen.this.actualResult, AxonTestWhen.this.actualException);
        }
    }

    class Event
    implements AxonTestPhase.When.Event {
        Event() {
        }

        @Override
        public AxonTestPhase.Then.Event then() {
            return new AxonTestThenEvent(AxonTestWhen.this.configuration, AxonTestWhen.this.customization, AxonTestWhen.this.commandBus, AxonTestWhen.this.eventSink, AxonTestWhen.this.actualException);
        }
    }
}

