/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.eventscheduler;

import java.time.Instant;
import java.util.Objects;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.messaging.Message;
import org.axonframework.test.eventscheduler.ScheduledItem;

public class StubScheduleToken
implements ScheduleToken,
Comparable<StubScheduleToken>,
ScheduledItem {
    private final Instant scheduleTime;
    private final EventMessage event;
    private final int counter;

    StubScheduleToken(Instant scheduleTime, EventMessage event, int counter) {
        this.scheduleTime = scheduleTime;
        this.event = event;
        this.counter = counter;
    }

    @Override
    public Instant getScheduleTime() {
        return this.scheduleTime;
    }

    @Override
    public EventMessage getEvent() {
        return new GenericEventMessage((Message)this.event, () -> this.scheduleTime);
    }

    @Override
    public int compareTo(StubScheduleToken other) {
        if (this.scheduleTime.equals(other.scheduleTime)) {
            return this.counter < other.counter ? -1 : (this.counter == other.counter ? 0 : 1);
        }
        return this.scheduleTime.compareTo(other.scheduleTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubScheduleToken that = (StubScheduleToken)o;
        return this.counter == that.counter && Objects.equals(this.scheduleTime, that.scheduleTime);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleTime, this.counter);
    }
}

