/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotatedCommandHandlingComponent;
import org.axonframework.common.Assert;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackingEventStream;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.LegacyEventSourcingRepository;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.messaging.ApplicationContext;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.EmptyApplicationContext;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.LegacyMessageSupportingContext;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateAnnotationCommandHandler;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.LegacyRepository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregate;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.serialization.PassThroughConverter;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.aggregate.FixtureConfiguration;
import org.axonframework.test.aggregate.ResultValidator;
import org.axonframework.test.aggregate.ResultValidatorImpl;
import org.axonframework.test.aggregate.TestExecutor;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.matchers.MatchAllFieldFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="5.0.0", forRemoval=true)
public class AggregateTestFixture<T>
implements FixtureConfiguration<T>,
TestExecutor<T> {
    private static final Logger logger = LoggerFactory.getLogger(AggregateTestFixture.class);
    private final Class<T> aggregateType;
    private final Set<Class<? extends T>> subtypes = new HashSet<Class<? extends T>>();
    private final SimpleCommandBus commandBus;
    private final LegacyEventStore eventStore;
    private final List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
    private final List<Object> resources = new ArrayList<Object>();
    private boolean useStateStorage;
    private RepositoryProvider repositoryProvider;
    private IdentifierValidatingRepository<T> repository;
    private final StubDeadlineManager deadlineManager;
    private String aggregateIdentifier;
    private Deque<DomainEventMessage> givenEvents;
    private Deque<DomainEventMessage> storedEvents;
    private List<EventMessage> publishedEvents;
    private long sequenceNumber;
    private boolean reportIllegalStateChange = true;
    private boolean explicitCommandHandlersSet;
    private final LinkedList<ParameterResolverFactory> registeredParameterResolverFactories = new LinkedList();
    private final LinkedList<HandlerDefinition> registeredHandlerDefinitions = new LinkedList();
    private final LinkedList<HandlerEnhancerDefinition> registeredHandlerEnhancerDefinitions = new LinkedList();
    private CommandTargetResolver commandTargetResolver;

    public AggregateTestFixture(Class<T> aggregateType) {
        this.deadlineManager = new StubDeadlineManager();
        this.commandBus = new SimpleCommandBus((UnitOfWorkFactory)new SimpleUnitOfWorkFactory((ApplicationContext)EmptyApplicationContext.INSTANCE), Collections.emptyList());
        this.eventStore = new RecordingEventStore();
        this.resources.add(this.commandBus);
        this.resources.add(this.eventStore);
        this.resources.add(this.deadlineManager);
        this.aggregateType = aggregateType;
        this.storedEvents = new LinkedList<DomainEventMessage>();
        this.publishedEvents = new ArrayList<EventMessage>();
        this.givenEvents = new LinkedList<DomainEventMessage>();
        this.sequenceNumber = 0L;
        this.registeredParameterResolverFactories.add((ParameterResolverFactory)new SimpleResourceParameterResolverFactory(this.resources));
        this.registeredParameterResolverFactories.add(ClasspathParameterResolverFactory.forClass(aggregateType));
        this.registeredHandlerDefinitions.add((HandlerDefinition)ClasspathHandlerDefinition.forClass(aggregateType));
        this.registeredHandlerEnhancerDefinitions.add((HandlerEnhancerDefinition)ClasspathHandlerEnhancerDefinition.forClass(aggregateType));
    }

    @Override
    @SafeVarargs
    public final FixtureConfiguration<T> withSubtypes(Class<? extends T> ... subtypes) {
        this.subtypes.addAll(Arrays.asList(subtypes));
        return this;
    }

    @Override
    public FixtureConfiguration<T> useStateStorage() {
        this.useStateStorage = true;
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerRepository(LegacyRepository<T> repository) {
        this.repository = new IdentifierValidatingRepository<T>(repository);
        this.resources.add(repository);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerRepositoryProvider(RepositoryProvider repositoryProvider) {
        if (this.repository != null) {
            throw new FixtureExecutionException("Cannot register a RepositoryProvider since the Repository is already defined in this fixture. It is recommended to first a RepositoryProvider and then register or retrieve the Repository.");
        }
        this.repositoryProvider = repositoryProvider;
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerAggregateFactory(AggregateFactory<T> aggregateFactory) {
        return this.registerRepository((LegacyRepository<T>)LegacyEventSourcingRepository.builder((Class)aggregateFactory.getAggregateType()).aggregateFactory(aggregateFactory).eventStore(this.eventStore).parameterResolverFactory(this.getParameterResolverFactory()).handlerDefinition(this.getHandlerDefinition()).repositoryProvider(this.getRepositoryProvider()).build());
    }

    @Override
    public synchronized FixtureConfiguration<T> registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.commandBus.subscribe((CommandHandlingComponent)new AnnotatedCommandHandlingComponent(annotatedCommandHandler, this.getParameterResolverFactory(), this.getHandlerDefinition(), (MessageTypeResolver)new ClassBasedMessageTypeResolver(), PassThroughConverter.MESSAGE_INSTANCE));
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(Class<?> payloadType, MessageHandler<CommandMessage, CommandResultMessage<?>> commandHandler) {
        return this.registerCommandHandler(payloadType.getName(), commandHandler);
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(String commandName, MessageHandler<CommandMessage, CommandResultMessage<?>> commandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.commandBus.subscribe(new QualifiedName(commandName), (CommandHandler)commandHandler);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerInjectableResource(Object resource) {
        if (this.explicitCommandHandlersSet) {
            throw new FixtureExecutionException("Cannot inject resources after command handler has been created. Configure all resource before calling registerCommandHandler() or registerAnnotatedCommandHandler()");
        }
        this.resources.add(resource);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        if (this.repository != null) {
            throw new FixtureExecutionException("Cannot register more ParameterResolverFactories since the Repository is already defined in this fixture. It is recommended to first register ParameterResolverFactories and then register or retrieve the Repository.");
        }
        this.registeredParameterResolverFactories.addFirst(parameterResolverFactory);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage> commandDispatchInterceptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage> commandHandlerInterceptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public FixtureConfiguration<T> registerDeadlineDispatchInterceptor(MessageDispatchInterceptor<? super DeadlineMessage> deadlineDispatchInterceptor) {
        this.deadlineManager.registerDispatchInterceptor(deadlineDispatchInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerDeadlineHandlerInterceptor(MessageHandlerInterceptor<DeadlineMessage> deadlineHandlerInterceptor) {
        this.deadlineManager.registerHandlerInterceptor(deadlineHandlerInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    @Override
    public FixtureConfiguration<T> registerHandlerDefinition(HandlerDefinition handlerDefinition) {
        if (this.repository != null) {
            throw new FixtureExecutionException("Cannot register more HandlerDefinitions since the Repository is already defined in this fixture. It is recommended to first register HandlerDefinitions and then register or retrieve the Repository.");
        }
        this.registeredHandlerDefinitions.addFirst(handlerDefinition);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerHandlerEnhancerDefinition(HandlerEnhancerDefinition handlerEnhancerDefinition) {
        if (this.repository != null) {
            throw new FixtureExecutionException("Cannot register more HandlerEnhancerDefinitions since the Repository is already defined in this fixture. It is recommended to first register HandlerEnhancerDefinitions and then register or retrieve the Repository.");
        }
        this.registeredHandlerEnhancerDefinitions.addFirst(handlerEnhancerDefinition);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandTargetResolver(CommandTargetResolver commandTargetResolver) {
        this.commandTargetResolver = commandTargetResolver;
        return this;
    }

    @Override
    public TestExecutor<T> given(Object ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor<T> andGiven(Object ... domainEvents) {
        return this.andGiven(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor<T> givenNoPriorActivity() {
        this.ensureRepositoryConfiguration();
        this.clearGivenWhenState();
        return this;
    }

    @Override
    public TestExecutor<T> givenState(Supplier<T> aggregate) {
        if (this.repository == null) {
            this.useStateStorage();
        }
        this.ensureRepositoryConfiguration();
        LegacyDefaultUnitOfWork.startAndGet(null).execute(ctx -> {
            try {
                this.repository.newInstance(((Supplier)aggregate)::get);
            }
            catch (Exception e) {
                throw new FixtureExecutionException("An exception occurred while trying to initialize repository with given aggregate (using 'givenState')", e);
            }
        });
        this.clearGivenWhenState();
        return this;
    }

    @Override
    public TestExecutor<T> given(List<?> domainEvents) {
        this.ensureRepositoryConfiguration();
        this.clearGivenWhenState();
        return this.andGiven(domainEvents);
    }

    @Override
    public TestExecutor<T> andGiven(List<?> domainEvents) {
        if (this.useStateStorage) {
            throw new FixtureExecutionException("Given events not supported, because the fixture is configured to use state storage");
        }
        for (Object event : domainEvents) {
            Object payload = event;
            MetaData metaData = null;
            String type = this.aggregateType.getSimpleName();
            if (event instanceof Message) {
                payload = ((Message)event).payload();
                metaData = ((Message)event).metaData();
            }
            if (event instanceof DomainEventMessage) {
                type = ((DomainEventMessage)event).getType();
            }
            GenericDomainEventMessage eventMessage = new GenericDomainEventMessage(type, this.aggregateIdentifier, this.sequenceNumber++, (Message)new GenericMessage(new MessageType(payload.getClass()), payload, (Map)metaData), this.deadlineManager.getCurrentDateTime());
            this.givenEvents.add((DomainEventMessage)eventMessage);
        }
        return this;
    }

    @Override
    public TestExecutor<T> givenCommands(Object ... commands) {
        return this.givenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor<T> andGivenCommands(Object ... commands) {
        return this.andGivenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor<T> givenCommands(List<?> commands) {
        this.clearGivenWhenState();
        return this.andGivenCommands(commands);
    }

    @Override
    public TestExecutor<T> andGivenCommands(List<?> commands) {
        this.finalizeConfiguration();
        for (Object command : commands) {
            CompletableFuture result = new CompletableFuture();
            GenericCommandMessage commandMessage = new GenericCommandMessage(new MessageType(command.getClass()), command);
            this.executeAtSimulatedTime(() -> this.lambda$andGivenCommands$1((CommandMessage)commandMessage, result));
            result.join();
            this.givenEvents.addAll(this.storedEvents);
            this.storedEvents.clear();
        }
        this.publishedEvents.clear();
        return this;
    }

    private void executeAtSimulatedTime(Runnable runnable) {
        Clock previousClock = GenericEventMessage.clock;
        try {
            GenericEventMessage.clock = Clock.fixed(this.currentTime(), ZoneOffset.UTC);
            runnable.run();
        }
        finally {
            GenericEventMessage.clock = previousClock;
        }
    }

    @Override
    public TestExecutor<T> givenCurrentTime(Instant currentTime) {
        this.clearGivenWhenState();
        return this.andGivenCurrentTime(currentTime);
    }

    @Override
    public TestExecutor<T> andGivenCurrentTime(Instant currentTime) {
        this.deadlineManager.initializeAt(currentTime);
        return this;
    }

    @Override
    public Instant currentTime() {
        return this.deadlineManager.getCurrentDateTime();
    }

    @Override
    public ResultValidator<T> whenTimeElapses(Duration elapsedTime) {
        logger.debug("Starting WHEN-phase");
        this.deadlineManager.advanceTimeBy(elapsedTime, this::handleDeadline);
        return this.buildResultValidator();
    }

    @Override
    public ResultValidator<T> whenTimeAdvancesTo(Instant newPointInTime) {
        logger.debug("Starting WHEN-phase");
        this.deadlineManager.advanceTimeTo(newPointInTime, this::handleDeadline);
        return this.buildResultValidator();
    }

    @Override
    public ResultValidator<T> when(Object command) {
        return this.when(command, (Map<String, String>)MetaData.emptyInstance());
    }

    @Override
    public ResultValidator<T> when(Object command, Map<String, String> metaData) {
        return this.when((ResultValidatorImpl<T> resultValidator) -> {
            GenericCommandMessage commandMessage = new GenericCommandMessage(new MessageType(command.getClass()), command, metaData);
            this.commandBus.dispatch((CommandMessage)commandMessage, (ProcessingContext)new LegacyMessageSupportingContext((Message)commandMessage)).whenComplete((arg_0, arg_1) -> AggregateTestFixture.lambda$when$2(resultValidator, (CommandMessage)commandMessage, arg_0, arg_1));
        });
    }

    @Override
    public ResultValidator<T> whenConstructing(Callable<T> aggregateFactory) {
        return this.when((ResultValidatorImpl<T> validator) -> LegacyDefaultUnitOfWork.startAndGet(null).execute(ctx -> {
            try {
                this.repository.newInstance(aggregateFactory);
            }
            catch (AssertionError | Exception e) {
                validator.recordException((Throwable)e);
            }
        }));
    }

    @Override
    public ResultValidator<T> whenInvoking(String aggregateId, Consumer<T> aggregateSupplier) {
        return this.when((ResultValidatorImpl<T> validator) -> LegacyDefaultUnitOfWork.startAndGet(null).execute(ctx -> {
            try {
                this.repository.load(aggregateId).execute(aggregateSupplier);
            }
            catch (AssertionError | Exception e) {
                validator.recordException((Throwable)e);
            }
        }));
    }

    private ResultValidator<T> when(Consumer<ResultValidatorImpl<T>> whenPhase) {
        logger.debug("Starting WHEN-phase");
        this.finalizeConfiguration();
        MatchAllFieldFilter fieldFilter = new MatchAllFieldFilter(this.fieldFilters);
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.publishedEvents, fieldFilter, () -> this.repository.getAggregate(), this.deadlineManager);
        this.executeAtSimulatedTime(() -> whenPhase.accept(resultValidator));
        if (!this.repository.rolledBack) {
            Aggregate workingAggregate = this.repository.aggregate;
            this.detectIllegalStateChanges(fieldFilter, workingAggregate);
        }
        resultValidator.assertValidRecording();
        logger.debug("Starting EXPECT-phase");
        return resultValidator;
    }

    protected void handleDeadline(ScopeDescriptor aggregateDescriptor, DeadlineMessage deadlineMessage) throws Exception {
        this.ensureRepositoryConfiguration();
        this.repository.send((Message)deadlineMessage, (ProcessingContext)new LegacyMessageSupportingContext((Message)deadlineMessage), aggregateDescriptor);
    }

    private ResultValidator<T> buildResultValidator() {
        MatchAllFieldFilter fieldFilter = new MatchAllFieldFilter(this.fieldFilters);
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.publishedEvents, fieldFilter, () -> this.repository.getAggregate(), this.deadlineManager);
        resultValidator.assertValidRecording();
        logger.debug("Starting EXPECT-phase");
        return resultValidator;
    }

    private void finalizeConfiguration() {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
    }

    private void registerAggregateCommandHandlers() {
        this.ensureRepositoryConfiguration();
        if (!this.explicitCommandHandlersSet) {
            AggregateAnnotationCommandHandler.Builder builder = AggregateAnnotationCommandHandler.builder().aggregateType(this.aggregateType).aggregateModel(this.aggregateModel()).parameterResolverFactory(this.getParameterResolverFactory()).repository(this.repository);
            if (this.commandTargetResolver != null) {
                builder.commandTargetResolver(this.commandTargetResolver);
            }
            this.commandBus.subscribe((CommandHandlingComponent)builder.build());
        }
    }

    private void ensureRepositoryConfiguration() {
        if (this.repository != null) {
            return;
        }
        if (this.useStateStorage) {
            this.registerRepository(new InMemoryRepository<T>(this.aggregateType, this.subtypes, (EventBus)this.eventStore, this.getParameterResolverFactory(), this.getHandlerDefinition(), this.getRepositoryProvider()));
        } else {
            AggregateModel<T> aggregateModel = this.aggregateModel();
            this.registerRepository((LegacyRepository<T>)LegacyEventSourcingRepository.builder(this.aggregateType).aggregateModel(aggregateModel).aggregateFactory((AggregateFactory)new GenericAggregateFactory(aggregateModel)).eventStore(this.eventStore).parameterResolverFactory(this.getParameterResolverFactory()).handlerDefinition(this.getHandlerDefinition()).repositoryProvider(this.getRepositoryProvider()).build());
        }
    }

    private AggregateModel<T> aggregateModel() {
        return AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, (ParameterResolverFactory)this.getParameterResolverFactory(), (HandlerDefinition)this.getHandlerDefinition(), this.subtypes);
    }

    private ParameterResolverFactory getParameterResolverFactory() {
        return MultiParameterResolverFactory.ordered(this.registeredParameterResolverFactories);
    }

    private HandlerDefinition getHandlerDefinition() {
        MultiHandlerEnhancerDefinition handlerEnhancerDefinition = MultiHandlerEnhancerDefinition.ordered(this.registeredHandlerEnhancerDefinitions);
        return MultiHandlerDefinition.ordered(this.registeredHandlerDefinitions, (HandlerEnhancerDefinition)handlerEnhancerDefinition);
    }

    private RepositoryProvider getRepositoryProvider() {
        if (this.repositoryProvider == null) {
            this.registerRepositoryProvider(new DefaultRepositoryProvider());
        }
        return this.repositoryProvider;
    }

    private void detectIllegalStateChanges(MatchAllFieldFilter fieldFilter, Aggregate<T> workingAggregate) {
        logger.debug("Starting separate Unit of Work for the purpose of checking illegal state changes in Aggregate");
        if (this.aggregateIdentifier != null && workingAggregate != null && this.reportIllegalStateChange) {
            LegacyDefaultUnitOfWork uow = LegacyDefaultUnitOfWork.startAndGet(null);
            try {
                Aggregate aggregate2 = this.repository.delegate.load(this.aggregateIdentifier);
                if (workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was considered deleted, but the Repository still contains a non-deleted copy of the aggregate. Make sure the aggregate explicitly marks itself as deleted in an EventHandler.");
                }
                this.assertValidWorkingAggregateState(aggregate2, fieldFilter, workingAggregate);
            }
            catch (AggregateNotFoundException notFound) {
                if (!workingAggregate.isDeleted() && workingAggregate.identifier() != null) {
                    throw new AxonAssertionError("The working aggregate was not considered deleted, but the Repository cannot recover the state of the aggregate, as it is considered deleted there.");
                }
            }
            catch (Exception e) {
                throw new FixtureExecutionException("An Exception occurred while reconstructing the Aggregate from given and published events. This may be an indication that the aggregate cannot be recreated from its events.", e);
            }
            finally {
                uow.rollback();
            }
        }
    }

    private void assertValidWorkingAggregateState(Aggregate<T> eventSourcedAggregate, MatchAllFieldFilter fieldFilter, Aggregate<T> workingAggregate) {
        HashSet<ComparationEntry> comparedEntries = new HashSet<ComparationEntry>();
        if (!workingAggregate.rootType().equals(eventSourcedAggregate.rootType())) {
            throw new AxonAssertionError(String.format("The aggregate loaded based on the generated events seems to be of another type than the original.\nWorking type: <%s>\nEvent Sourced type: <%s>", workingAggregate.rootType().getName(), eventSourcedAggregate.rootType().getName()));
        }
        this.ensureValuesEqual(workingAggregate.invoke(Function.identity()), eventSourcedAggregate.invoke(Function.identity()), eventSourcedAggregate.rootType().getName(), comparedEntries, fieldFilter);
    }

    private void ensureValuesEqual(Object workingValue, Object eventSourcedValue, String propertyPath, Set<ComparationEntry> comparedEntries, FieldFilter fieldFilter) {
        if (Objects.equals(workingValue, eventSourcedValue)) {
            return;
        }
        if (workingValue == null || ReflectionUtils.hasEqualsMethod(workingValue.getClass()) || eventSourcedValue == null || ReflectionUtils.hasEqualsMethod(eventSourcedValue.getClass())) {
            this.failIllegalStateChange(workingValue, eventSourcedValue, propertyPath);
        } else if (comparedEntries.add(new ComparationEntry(workingValue, eventSourcedValue)) && !ReflectionUtils.hasEqualsMethod(workingValue.getClass())) {
            try {
                for (Field field : ReflectionUtils.fieldsOf(workingValue.getClass())) {
                    if (!fieldFilter.accept(field) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                    ReflectionUtils.ensureAccessible((AccessibleObject)field);
                    String newPropertyPath = propertyPath + "." + field.getName();
                    Object workingFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)workingValue);
                    Object eventSourcedFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)eventSourcedValue);
                    this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, newPropertyPath, comparedEntries, fieldFilter);
                }
            }
            catch (Exception e) {
                logger.debug("Exception while attempting to verify deep equality.", (Throwable)e);
                this.failIllegalStateChange(workingValue, eventSourcedValue, propertyPath);
            }
        }
    }

    private void failIllegalStateChange(Object workingValue, Object eventSourcedValue, String propertyPath) {
        throw new AxonAssertionError(String.format("Illegal state change detected! Property \"%s\" has different value when sourcing events.\nWorking aggregate value:     <%s>\nValue after applying events: <%s>", propertyPath, workingValue, eventSourcedValue));
    }

    private void clearGivenWhenState() {
        logger.debug("Starting GIVEN-phase");
        this.storedEvents = new LinkedList<DomainEventMessage>();
        this.publishedEvents = new ArrayList<EventMessage>();
        this.givenEvents = new LinkedList<DomainEventMessage>();
        this.sequenceNumber = 0L;
    }

    @Override
    public void setReportIllegalStateChange(boolean reportIllegalStateChange) {
        this.reportIllegalStateChange = reportIllegalStateChange;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventStore;
    }

    @Override
    public LegacyEventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public LegacyRepository<T> getRepository() {
        this.ensureRepositoryConfiguration();
        return this.repository;
    }

    private static /* synthetic */ void lambda$when$2(ResultValidatorImpl resultValidator, CommandMessage commandMessage, CommandResultMessage r, Throwable e) {
        if (e == null) {
            resultValidator.recordResult(commandMessage, (Message)r);
        } else {
            resultValidator.recordException(e);
        }
    }

    private /* synthetic */ void lambda$andGivenCommands$1(CommandMessage commandMessage, CompletableFuture result) {
        this.commandBus.dispatch(commandMessage, (ProcessingContext)new LegacyMessageSupportingContext((Message)commandMessage)).whenComplete(FutureUtils.alsoComplete((CompletableFuture)result));
    }

    private class RecordingEventStore
    implements LegacyEventStore {
        private RecordingEventStore() {
        }

        public DomainEventStream readEvents(@Nonnull String identifier) {
            if (AggregateTestFixture.this.aggregateIdentifier != null && !AggregateTestFixture.this.aggregateIdentifier.equals(identifier)) {
                String exceptionMessage = String.format("The aggregate identifier used in the 'when' step does not resemble the aggregate identifier used in the 'given' step. Please make sure the when-identifier [%s] resembles the given-identifier [%s].", identifier, AggregateTestFixture.this.aggregateIdentifier);
                throw new EventStoreException(exceptionMessage);
            }
            if (AggregateTestFixture.this.aggregateIdentifier == null) {
                AggregateTestFixture.this.aggregateIdentifier = identifier;
                this.injectAggregateIdentifier();
            }
            ArrayList<DomainEventMessage> allEvents = new ArrayList<DomainEventMessage>(AggregateTestFixture.this.givenEvents);
            allEvents.addAll(AggregateTestFixture.this.storedEvents);
            if (allEvents.isEmpty()) {
                throw new AggregateNotFoundException(identifier, "No 'given' events were configured for this aggregate, nor have any events been stored.");
            }
            return DomainEventStream.of(allEvents);
        }

        public void publish(@Nonnull List<? extends EventMessage> events) {
            if (CurrentUnitOfWork.isStarted()) {
                CurrentUnitOfWork.get().onPrepareCommit(u -> this.doAppendEvents(events));
            } else {
                this.doAppendEvents(events);
            }
        }

        protected void doAppendEvents(List<? extends EventMessage> events) {
            events.forEach(e -> {
                DomainEventMessage lastEvent;
                if (!DomainEventMessage.class.isInstance(e)) {
                    AggregateTestFixture.this.publishedEvents.add((EventMessage)e);
                    return;
                }
                DomainEventMessage event = (DomainEventMessage)e;
                if (AggregateTestFixture.this.aggregateIdentifier == null) {
                    AggregateTestFixture.this.aggregateIdentifier = event.getAggregateIdentifier();
                    this.injectAggregateIdentifier();
                }
                if ((lastEvent = (AggregateTestFixture.this.storedEvents.isEmpty() ? AggregateTestFixture.this.givenEvents : AggregateTestFixture.this.storedEvents).peekLast()) != null) {
                    if (!lastEvent.getAggregateIdentifier().equals(event.getAggregateIdentifier())) {
                        throw new EventStoreException("Writing events for an unexpected aggregate. This could indicate that a wrong aggregate is being triggered.");
                    }
                    if (lastEvent.getSequenceNumber() != event.getSequenceNumber() - 1L) {
                        throw new EventStoreException(String.format("Unexpected sequence number on stored event. Expected %s, \n but got %s.", lastEvent.getSequenceNumber() + 1L, event.getSequenceNumber()));
                    }
                }
                AggregateTestFixture.this.publishedEvents.add((EventMessage)event);
                AggregateTestFixture.this.storedEvents.add(event);
            });
        }

        private void injectAggregateIdentifier() {
            ArrayList<DomainEventMessage> oldEvents = new ArrayList<DomainEventMessage>(AggregateTestFixture.this.givenEvents);
            AggregateTestFixture.this.givenEvents.clear();
            for (DomainEventMessage oldEvent : oldEvents) {
                if (oldEvent.getAggregateIdentifier() == null) {
                    AggregateTestFixture.this.givenEvents.add((DomainEventMessage)new GenericDomainEventMessage(oldEvent.getType(), AggregateTestFixture.this.aggregateIdentifier, oldEvent.getSequenceNumber(), oldEvent.identifier(), oldEvent.type(), oldEvent.payload(), (Map)oldEvent.metaData(), oldEvent.timestamp()));
                    continue;
                }
                AggregateTestFixture.this.givenEvents.add(oldEvent);
            }
        }

        public TrackingEventStream openStream(TrackingToken trackingToken) {
            throw new UnsupportedOperationException();
        }

        public void storeSnapshot(@Nonnull DomainEventMessage snapshot) {
        }

        @Nonnull
        public Registration subscribe(@Nonnull Consumer<List<? extends EventMessage>> eventProcessor) {
            return () -> true;
        }

        @Nonnull
        public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super EventMessage> dispatchInterceptor) {
            return () -> true;
        }
    }

    private static class IdentifierValidatingRepository<T>
    implements LegacyRepository<T> {
        private final LegacyRepository<T> delegate;
        private Aggregate<T> aggregate;
        private boolean rolledBack;

        public IdentifierValidatingRepository(LegacyRepository<T> delegate) {
            this.delegate = delegate;
        }

        public Aggregate<T> loadOrCreate(@Nonnull String aggregateIdentifier, @Nonnull Callable<T> factoryMethod) throws Exception {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.loadOrCreate(aggregateIdentifier, factoryMethod);
            return this.aggregate;
        }

        public Aggregate<T> newInstance(@Nonnull Callable<T> factoryMethod) throws Exception {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.newInstance(factoryMethod);
            return this.aggregate;
        }

        public Aggregate<T> load(@Nonnull String aggregateIdentifier) {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.load(aggregateIdentifier);
            this.validateIdentifier(aggregateIdentifier, this.aggregate);
            return this.aggregate;
        }

        private void validateIdentifier(String aggregateIdentifier, Aggregate<T> aggregate) {
            if (aggregateIdentifier != null && !aggregateIdentifier.equals(aggregate.identifierAsString())) {
                throw new AssertionError((Object)String.format("The aggregate used in this fixture was initialized with an identifier different than the one used to load it. Loaded [%s], but actual identifier is [%s].\nMake sure the identifier passed during construction matches that of the when-phase.", aggregateIdentifier, aggregate.identifierAsString()));
            }
        }

        public Aggregate<T> getAggregate() {
            Assert.state((!this.rolledBack ? 1 : 0) != 0, () -> "The state of this aggregate cannot be retrieved because it has been modified in a Unit of Work that was rolled back");
            return this.aggregate;
        }

        public void send(Message message, ProcessingContext context, ScopeDescriptor scopeDescription) throws Exception {
            if (this.canResolve(scopeDescription)) {
                this.load(((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString()).handle(message, context);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor;
        }
    }

    private static class InMemoryRepository<T>
    implements LegacyRepository<T> {
        private final EventBus eventBus;
        private final RepositoryProvider repositoryProvider;
        private final AggregateModel<T> aggregateModel;
        private AnnotatedAggregate<T> storedAggregate;

        protected InMemoryRepository(Class<T> aggregateType, Set<Class<? extends T>> subtypes, EventBus eventBus, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
            this.aggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateType, (ParameterResolverFactory)parameterResolverFactory, (HandlerDefinition)handlerDefinition, subtypes);
            this.eventBus = eventBus;
            this.repositoryProvider = repositoryProvider;
        }

        public Aggregate<T> newInstance(@Nonnull Callable<T> factoryMethod) throws Exception {
            Assert.state((this.storedAggregate == null ? 1 : 0) != 0, () -> "Creating an Aggregate while one is already stored. Test fixtures do not allow multiple instances to be stored.");
            this.storedAggregate = AnnotatedAggregate.initialize(factoryMethod, this.aggregateModel, (EventBus)this.eventBus, (RepositoryProvider)this.repositoryProvider, (boolean)true);
            return this.storedAggregate;
        }

        public Aggregate<T> load(@Nonnull String aggregateIdentifier) {
            if (this.storedAggregate == null) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. No aggregate has been stored yet.");
            }
            if (!aggregateIdentifier.equals(this.storedAggregate.identifier().toString())) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. Did you mean to load " + String.valueOf(this.storedAggregate.identifier()) + "?");
            }
            if (this.storedAggregate.isDeleted()) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. It has been deleted.");
            }
            return this.storedAggregate;
        }

        public void send(Message message, ProcessingContext context, ScopeDescriptor scopeDescription) throws Exception {
            if (this.canResolve(scopeDescription)) {
                this.load(((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString()).handle(message, context);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor;
        }

        public Aggregate<T> loadOrCreate(@Nonnull String aggregateIdentifier, @Nonnull Callable<T> factoryMethod) throws Exception {
            if (this.storedAggregate == null) {
                return this.newInstance(factoryMethod);
            }
            return this.load(aggregateIdentifier);
        }
    }

    private class DefaultRepositoryProvider
    implements RepositoryProvider {
        private DefaultRepositoryProvider() {
        }

        public <R> LegacyRepository<R> repositoryFor(@Nonnull Class<R> aggregateType) {
            return new CreationalRepository<R>(aggregateType, this);
        }
    }

    private static class ComparationEntry {
        private final Object workingObject;
        private final Object eventSourceObject;

        public ComparationEntry(Object workingObject, Object eventSourceObject) {
            this.workingObject = workingObject;
            this.eventSourceObject = eventSourceObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparationEntry that = (ComparationEntry)o;
            return Objects.equals(this.workingObject, that.workingObject) && Objects.equals(this.eventSourceObject, that.eventSourceObject);
        }

        public int hashCode() {
            return Objects.hash(this.workingObject, this.eventSourceObject);
        }
    }

    private class CreationalRepository<R>
    implements LegacyRepository<R> {
        private final Class<R> aggregateType;
        private final RepositoryProvider repositoryProvider;

        private CreationalRepository(Class<R> aggregateType, RepositoryProvider repositoryProvider) {
            this.aggregateType = aggregateType;
            this.repositoryProvider = repositoryProvider;
        }

        public Aggregate<R> load(@Nonnull String aggregateIdentifier) {
            throw new UnsupportedOperationException("Default repository does not mock loading of an aggregate, only creation of it");
        }

        public Aggregate<R> newInstance(@Nonnull Callable<R> factoryMethod) throws Exception {
            AggregateModel aggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, (ParameterResolverFactory)AggregateTestFixture.this.getParameterResolverFactory(), (HandlerDefinition)AggregateTestFixture.this.getHandlerDefinition());
            return EventSourcedAggregate.initialize(factoryMethod, (AggregateModel)aggregateModel, (EventBus)AggregateTestFixture.this.eventStore, (RepositoryProvider)this.repositoryProvider);
        }

        public void send(Message message, ProcessingContext context, ScopeDescriptor scopeDescription) {
            throw new UnsupportedOperationException("Default repository does not mock loading of an aggregate, only creation of it");
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return false;
        }
    }
}

