/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.server;

import java.util.Objects;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@Deprecated
public class AxonServerSEContainer<SELF extends AxonServerSEContainer<SELF>>
extends GenericContainer<SELF> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"axoniq/axonserver");
    private static final int AXON_SERVER_HTTP_PORT = 8024;
    private static final int AXON_SERVER_GRPC_PORT = 8124;
    private static final String WAIT_FOR_LOG_MESSAGE = ".*Started AxonServer.*";
    private static final String AXONIQ_AXONSERVER_DEVMODE_ENABLED = "AXONIQ_AXONSERVER_DEVMODE_ENABLED";
    private static final String AXON_SERVER_ADDRESS_TEMPLATE = "%s:%s";
    private boolean devMode;

    public AxonServerSEContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public AxonServerSEContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8024, 8124});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)WAIT_FOR_LOG_MESSAGE, (int)1));
    }

    protected void configure() {
        this.withEnv(AXONIQ_AXONSERVER_DEVMODE_ENABLED, String.valueOf(this.devMode));
    }

    public SELF withDevMode(boolean devMode) {
        this.devMode = devMode;
        return (SELF)((Object)((AxonServerSEContainer)this.self()));
    }

    public Integer getGrpcPort() {
        return this.getMappedPort(8124);
    }

    public String getAxonServerAddress() {
        return String.format(AXON_SERVER_ADDRESS_TEMPLATE, this.getHost(), this.getMappedPort(8124));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AxonServerSEContainer that = (AxonServerSEContainer)((Object)o);
        return this.devMode == that.devMode;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.devMode);
    }

    public String toString() {
        return "AxonServerSEContainer{devMode=" + this.devMode + '}';
    }
}

