/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.eventscheduler.ScheduledItem;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class EventSchedulerValidator {
    private final StubEventScheduler eventScheduler;

    public EventSchedulerValidator(StubEventScheduler eventScheduler) {
        this.eventScheduler = eventScheduler;
    }

    public void assertScheduledEventMatching(Duration duration, Matcher<?> matcher) {
        Instant targetTime = this.eventScheduler.getCurrentDateTime().plus(duration);
        this.assertScheduledEventMatching(targetTime, matcher);
    }

    public void assertScheduledEventMatching(Instant scheduledTime, Matcher<?> matcher) {
        List<ScheduledItem> schedule = this.eventScheduler.getScheduledItems();
        for (ScheduledItem item : schedule) {
            if (!item.getScheduleTime().equals(scheduledTime) || !matcher.matches((Object)item.getEvent())) continue;
            return;
        }
        StringDescription expected = new StringDescription();
        StringDescription actual = new StringDescription();
        matcher.describeTo((Description)expected);
        this.describe(this.eventScheduler.getScheduledItems(), (Description)actual);
        throw new AxonAssertionError(String.format("Did not find an event at the given schedule. \nExpected:\n<%s> at <%s>\nGot:%s\n", expected, scheduledTime, actual));
    }

    private void describe(List<ScheduledItem> scheduledItems, Description description) {
        if (scheduledItems.isEmpty()) {
            description.appendText("\n<no scheduled events>");
        }
        for (ScheduledItem item : scheduledItems) {
            description.appendText("\n<").appendText(item.getEvent().toString()).appendText("> at <").appendText(DateTimeUtils.formatInstant((TemporalAccessor)item.getScheduleTime())).appendText(">");
        }
    }

    public void assertNoScheduledEvents() {
        List<ScheduledItem> scheduledItems = this.eventScheduler.getScheduledItems();
        if (scheduledItems != null && !scheduledItems.isEmpty()) {
            throw new AxonAssertionError("Expected no scheduled events, got " + scheduledItems.size());
        }
    }
}

