/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.CommandValidator;
import org.axonframework.test.saga.EventSchedulerValidator;
import org.axonframework.test.saga.EventValidator;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.RepositoryContentValidator;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class FixtureExecutionResultImpl<T>
implements FixtureExecutionResult {
    private final RepositoryContentValidator<T> repositoryContentValidator;
    private final EventValidator eventValidator;
    private final EventSchedulerValidator eventSchedulerValidator;
    private final CommandValidator commandValidator;
    private final FieldFilter fieldFilter;

    FixtureExecutionResultImpl(InMemorySagaStore sagaStore, StubEventScheduler eventScheduler, EventBus eventBus, RecordingCommandBus commandBus, Class<T> sagaType, FieldFilter fieldFilter) {
        this.fieldFilter = fieldFilter;
        this.commandValidator = new CommandValidator(commandBus, fieldFilter);
        this.repositoryContentValidator = new RepositoryContentValidator<T>(sagaType, sagaStore);
        this.eventValidator = new EventValidator(eventBus, fieldFilter);
        this.eventSchedulerValidator = new EventSchedulerValidator(eventScheduler);
    }

    public void startRecording() {
        this.eventValidator.startRecording();
        this.commandValidator.startRecording();
    }

    @Override
    public FixtureExecutionResult expectActiveSagas(int expected) {
        this.repositoryContentValidator.assertActiveSagas(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertNoAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(Duration duration, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(duration, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, Object applicationEvent) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(Matchers.equalTo(applicationEvent, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(Duration duration, Class<?> eventType) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(Instant scheduledTime, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Instant scheduledTime, Object applicationEvent) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(Matchers.equalTo(applicationEvent, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(Instant scheduledTime, Class<?> eventType) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommands(Object ... expected) {
        this.commandValidator.assertDispatchedEqualTo(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsMatching(Matcher<? extends List<? super CommandMessage<?>>> matcher) {
        this.commandValidator.assertDispatchedMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoDispatchedCommands() {
        this.commandValidator.assertDispatchedMatching(Matchers.noCommands());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvents() {
        this.eventSchedulerValidator.assertNoScheduledEvents();
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEventsMatching(Matcher<? extends List<? super EventMessage<?>>> matcher) {
        this.eventValidator.assertPublishedEventsMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEvents(Object ... expected) {
        this.eventValidator.assertPublishedEvents(expected);
        return this;
    }
}

