/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.model.AggregateLifecycle;
import org.axonframework.commandhandling.model.ApplyMore;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;

public class StubAggregateLifecycle
extends AggregateLifecycle {
    private Runnable registration;
    private List<EventMessage<?>> appliedMessages = new CopyOnWriteArrayList();
    private boolean deleted;

    public void activate() {
        this.registration = this.registerAsCurrent();
    }

    public void close() {
        if (this.registration != null) {
            this.registration.run();
        }
        this.registration = null;
    }

    protected boolean getIsLive() {
        return true;
    }

    protected void doMarkDeleted() {
        this.deleted = true;
    }

    protected <T> ApplyMore doApply(T payload, MetaData metaData) {
        this.appliedMessages.add((EventMessage<?>)new GenericEventMessage(payload, (Map)metaData));
        return new ApplyMore(){

            public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
                StubAggregateLifecycle.this.appliedMessages.add(GenericEventMessage.asEventMessage(payloadOrMessageSupplier.get()));
                return this;
            }

            public ApplyMore andThen(Runnable runnable) {
                runnable.run();
                return this;
            }
        };
    }

    public List<EventMessage<?>> getAppliedEvents() {
        return this.appliedMessages;
    }

    public List<Object> getAppliedEventPayloads() {
        return this.appliedMessages.stream().map(Message::getPayload).collect(Collectors.toList());
    }

    public boolean isMarkedDeleted() {
        return this.deleted;
    }
}

