/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGatewayFactory;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.saga.AnnotatedSagaManager;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.eventhandling.saga.repository.AnnotatedSagaRepository;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.saga.WhenState;
import org.axonframework.test.utils.AutowiredResourceInjector;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.RecordingCommandBus;

public class SagaTestFixture<T>
implements FixtureConfiguration,
ContinuedGivenState {
    private final StubEventScheduler eventScheduler;
    private final List<Object> registeredResources = new LinkedList<Object>();
    private final Map<Object, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<Object, AggregateEventPublisherImpl>();
    private final FixtureExecutionResultImpl<T> fixtureExecutionResult;
    private final RecordingCommandBus commandBus;
    private final MutableFieldFilter fieldFilters = new MutableFieldFilter();
    private final Class<T> sagaType;
    private final InMemorySagaStore sagaStore;
    private AnnotatedSagaManager<T> sagaManager;
    private boolean transienceCheckEnabled = true;

    public SagaTestFixture(Class<T> sagaType) {
        this.sagaType = sagaType;
        this.eventScheduler = new StubEventScheduler();
        SimpleEventBus eventBus = new SimpleEventBus();
        this.sagaStore = new InMemorySagaStore();
        this.registeredResources.add(eventBus);
        this.commandBus = new RecordingCommandBus();
        this.registeredResources.add(this.commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.registeredResources.add(new DefaultCommandGateway((CommandBus)this.commandBus, new MessageDispatchInterceptor[0]));
        this.fixtureExecutionResult = new FixtureExecutionResultImpl<T>(this.sagaStore, this.eventScheduler, (EventBus)eventBus, this.commandBus, sagaType, this.fieldFilters);
    }

    protected void handleInSaga(EventMessage<?> event) {
        this.ensureSagaManagerInitialized();
        try {
            DefaultUnitOfWork.startAndGet(event).executeWithResult(() -> this.sagaManager.handle(event));
        }
        catch (Exception e) {
            throw new FixtureExecutionException("Exception occurred while handling an event", e);
        }
    }

    protected void ensureSagaManagerInitialized() {
        if (this.sagaManager == null) {
            MultiParameterResolverFactory parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{new SimpleResourceParameterResolverFactory(this.registeredResources), ClasspathParameterResolverFactory.forClass(this.sagaType)});
            AnnotatedSagaRepository sagaRepository = new AnnotatedSagaRepository(this.sagaType, (SagaStore)this.sagaStore, (ResourceInjector)new TransienceValidatingResourceInjector(), (ParameterResolverFactory)parameterResolverFactory);
            this.sagaManager = new AnnotatedSagaManager(this.sagaType, (SagaRepository)sagaRepository, (ParameterResolverFactory)parameterResolverFactory);
            this.sagaManager.setSuppressExceptions(false);
        }
    }

    @Override
    public FixtureConfiguration withTransienceCheckDisabled() {
        this.transienceCheckEnabled = false;
        return this;
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTimeBy(elapsedTime, this::handleInSaga);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("Exception occurred while trying to advance time and handle scheduled events", e);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(Instant newDateTime) {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTimeTo(newDateTime, this::handleInSaga);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("Exception occurred while trying to advance time and handle scheduled events", e);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.add(resource);
    }

    @Override
    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.commandBus.setCallbackBehavior(callbackBehavior);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(String aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(Object event) {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public WhenState givenNoPriorActivity() {
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(String aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenTimeElapses(Duration elapsedTime) throws Exception {
        this.eventScheduler.advanceTimeBy(elapsedTime, this::handleInSaga);
        return this;
    }

    @Override
    public ContinuedGivenState andThenTimeAdvancesTo(Instant newDateTime) throws Exception {
        this.eventScheduler.advanceTimeTo(newDateTime, this::handleInSaga);
        return this;
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event) throws Exception {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(String aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event) {
        this.fixtureExecutionResult.startRecording();
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this.fixtureExecutionResult;
    }

    private EventMessage<Object> timeCorrectedEventMessage(Object event) {
        EventMessage msg = GenericEventMessage.asEventMessage((Object)event);
        return new GenericEventMessage(msg.getIdentifier(), msg.getPayload(), (Map)msg.getMetaData(), this.currentTime());
    }

    @Override
    public Instant currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface) {
        return this.registerCommandGateway(gatewayInterface, (I)null);
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface, I stubImplementation) {
        StubAwareCommandGatewayFactory factory = new StubAwareCommandGatewayFactory(stubImplementation, this.commandBus);
        Object gateway = factory.createGateway(gatewayInterface);
        this.registerResource(gateway);
        return (I)gateway;
    }

    @Override
    public FixtureConfiguration registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    private AggregateEventPublisherImpl getPublisherFor(String aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl(aggregateIdentifier));
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    private class TransienceValidatingResourceInjector
    extends AutowiredResourceInjector {
        public TransienceValidatingResourceInjector() {
            super(SagaTestFixture.this.registeredResources);
        }

        public void injectResources(Object saga) {
            super.injectResources(saga);
            if (SagaTestFixture.this.transienceCheckEnabled) {
                StreamSupport.stream(ReflectionUtils.fieldsOf(saga.getClass()).spliterator(), false).filter(f -> !Modifier.isTransient(f.getModifiers())).filter(f -> SagaTestFixture.this.registeredResources.contains(ReflectionUtils.getFieldValue((Field)f, (Object)saga))).findFirst().ifPresent(field -> {
                    throw new AssertionError((Object)String.format("Field %s.%s is injected with a resource, but it doesn't have the 'transient' modifier.\nMark field as 'transient' or disable this check using:\nfixture.withTransienceCheckDisabled()", field.getDeclaringClass(), field.getName()));
                });
            }
        }
    }

    private class MutableFieldFilter
    implements FieldFilter {
        private final List<FieldFilter> filters = new ArrayList<FieldFilter>();

        private MutableFieldFilter() {
        }

        @Override
        public boolean accept(Field field) {
            for (FieldFilter filter : this.filters) {
                if (filter.accept(field)) continue;
                return false;
            }
            return true;
        }

        public void add(FieldFilter fieldFilter) {
            this.filters.add(fieldFilter);
        }
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        private final String aggregateIdentifier;
        private final String type;
        private int sequenceNumber = 0;

        public AggregateEventPublisherImpl(String aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.type = "Stub_" + aggregateIdentifier;
        }

        @Override
        public ContinuedGivenState published(Object ... events) {
            this.publish(events);
            return SagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(Object event) {
            this.publish(event);
            return SagaTestFixture.this.fixtureExecutionResult;
        }

        private void publish(Object ... events) {
            for (Object event : events) {
                EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
                SagaTestFixture.this.handleInSaga((EventMessage<?>)new GenericDomainEventMessage(this.type, this.aggregateIdentifier, (long)this.sequenceNumber++, eventMessage.getPayload(), (Map)eventMessage.getMetaData(), eventMessage.getIdentifier(), SagaTestFixture.this.currentTime()));
            }
        }
    }

    private static class ReturnResultFromStub<R>
    implements CommandGatewayFactory.InvocationHandler<R> {
        private final CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> dispatcher;
        private final Object stubGateway;

        public ReturnResultFromStub(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> dispatcher, Object stubGateway) {
            this.dispatcher = dispatcher;
            this.stubGateway = stubGateway;
        }

        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            Future future = (Future)this.dispatcher.invoke(proxy, invokedMethod, args);
            if (this.stubGateway != null) {
                return (R)invokedMethod.invoke(this.stubGateway, args);
            }
            if (future.isDone()) {
                return (R)future.get();
            }
            return null;
        }
    }

    private static class StubAwareCommandGatewayFactory
    extends CommandGatewayFactory {
        private final Object stubImplementation;

        public StubAwareCommandGatewayFactory(Object stubImplementation, RecordingCommandBus commandBus) {
            super((CommandBus)commandBus, new MessageDispatchInterceptor[0]);
            this.stubImplementation = stubImplementation;
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToWaitForResult(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToReturnWithFixedTimeout(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToReturnWithTimeoutInArguments(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }
    }
}

