/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.gateway.GatewayProxyFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.saga.AnnotatedSagaManager;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.eventhandling.saga.repository.AnnotatedSagaRepository;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.test.FixtureResourceParameterResolverFactory;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.saga.WhenState;
import org.axonframework.test.utils.AutowiredResourceInjector;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.RecordingCommandBus;

public class AnnotatedSagaTestFixture<T>
implements FixtureConfiguration,
ContinuedGivenState {
    private final StubEventScheduler eventScheduler;
    private final AnnotatedSagaManager<T> sagaManager;
    private final List<Object> registeredResources = new LinkedList<Object>();
    private final Map<Object, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<Object, AggregateEventPublisherImpl>();
    private final FixtureExecutionResultImpl<T> fixtureExecutionResult;
    private final RecordingCommandBus commandBus;
    private final MutableFieldFilter fieldFilters = new MutableFieldFilter();

    public AnnotatedSagaTestFixture(Class<T> sagaType) {
        this.eventScheduler = new StubEventScheduler();
        SimpleEventBus eventBus = new SimpleEventBus();
        InMemorySagaStore sagaStore = new InMemorySagaStore();
        AnnotatedSagaRepository sagaRepository = new AnnotatedSagaRepository(sagaType, (SagaStore)sagaStore, (ResourceInjector)new AutowiredResourceInjector(this.registeredResources));
        this.sagaManager = new AnnotatedSagaManager(sagaType, (SagaRepository)sagaRepository);
        this.sagaManager.setSuppressExceptions(false);
        this.registeredResources.add(eventBus);
        this.commandBus = new RecordingCommandBus();
        this.registeredResources.add(this.commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.registeredResources.add(new DefaultCommandGateway((CommandBus)this.commandBus, new MessageDispatchInterceptor[0]));
        this.fixtureExecutionResult = new FixtureExecutionResultImpl<T>(sagaStore, this.eventScheduler, (EventBus)eventBus, this.commandBus, sagaType, this.fieldFilters);
        FixtureResourceParameterResolverFactory.clear();
        this.registeredResources.forEach(FixtureResourceParameterResolverFactory::registerResource);
    }

    protected void handleInSaga(EventMessage<?> event) throws Exception {
        DefaultUnitOfWork.startAndGet(event).executeWithResult(() -> this.sagaManager.handle(event));
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) throws Exception {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTime(elapsedTime, this::handleInSaga);
        }
        finally {
            FixtureResourceParameterResolverFactory.clear();
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(Instant newDateTime) throws Exception {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTime(newDateTime, this::handleInSaga);
        }
        finally {
            FixtureResourceParameterResolverFactory.clear();
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.add(resource);
        FixtureResourceParameterResolverFactory.registerResource(resource);
    }

    @Override
    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.commandBus.setCallbackBehavior(callbackBehavior);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(String aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(Object event) throws Exception {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public WhenState givenNoPriorActivity() {
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(String aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenTimeElapses(Duration elapsedTime) throws Exception {
        this.eventScheduler.advanceTime(elapsedTime, this::handleInSaga);
        return this;
    }

    @Override
    public ContinuedGivenState andThenTimeAdvancesTo(Instant newDateTime) throws Exception {
        this.eventScheduler.advanceTime(newDateTime, this::handleInSaga);
        return this;
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event) throws Exception {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(String aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event) throws Exception {
        try {
            this.fixtureExecutionResult.startRecording();
            this.handleInSaga(this.timeCorrectedEventMessage(event));
        }
        finally {
            FixtureResourceParameterResolverFactory.clear();
        }
        return this.fixtureExecutionResult;
    }

    private EventMessage<Object> timeCorrectedEventMessage(Object event) {
        EventMessage msg = GenericEventMessage.asEventMessage((Object)event);
        return new GenericEventMessage(msg.getIdentifier(), msg.getPayload(), (Map)msg.getMetaData(), this.currentTime());
    }

    @Override
    public Instant currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface) {
        return this.registerCommandGateway(gatewayInterface, (I)null);
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface, I stubImplementation) {
        StubAwareGatewayProxyFactory factory = new StubAwareGatewayProxyFactory(stubImplementation, this.commandBus);
        Object gateway = factory.createGateway(gatewayInterface);
        this.registerResource(gateway);
        return (I)gateway;
    }

    @Override
    public FixtureConfiguration registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    private AggregateEventPublisherImpl getPublisherFor(String aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl(aggregateIdentifier));
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    private class MutableFieldFilter
    implements FieldFilter {
        private final List<FieldFilter> filters = new ArrayList<FieldFilter>();

        private MutableFieldFilter() {
        }

        @Override
        public boolean accept(Field field) {
            for (FieldFilter filter : this.filters) {
                if (filter.accept(field)) continue;
                return false;
            }
            return true;
        }

        public void add(FieldFilter fieldFilter) {
            this.filters.add(fieldFilter);
        }
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        private final String aggregateIdentifier;
        private final String type;
        private int sequenceNumber = 0;

        public AggregateEventPublisherImpl(String aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.type = "Stub_" + aggregateIdentifier;
        }

        @Override
        public ContinuedGivenState published(Object ... events) throws Exception {
            this.publish(events);
            return AnnotatedSagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(Object event) throws Exception {
            try {
                this.publish(event);
            }
            finally {
                FixtureResourceParameterResolverFactory.clear();
            }
            return AnnotatedSagaTestFixture.this.fixtureExecutionResult;
        }

        private void publish(Object ... events) throws Exception {
            for (Object event : events) {
                EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
                AnnotatedSagaTestFixture.this.handleInSaga((EventMessage<?>)new GenericDomainEventMessage(this.type, this.aggregateIdentifier, (long)this.sequenceNumber++, eventMessage.getPayload(), (Map)eventMessage.getMetaData(), eventMessage.getIdentifier(), AnnotatedSagaTestFixture.this.currentTime()));
            }
        }
    }

    private static class ReturnResultFromStub<R>
    implements GatewayProxyFactory.InvocationHandler<R> {
        private final GatewayProxyFactory.InvocationHandler<Future<R>> dispatcher;
        private final Object stubGateway;

        public ReturnResultFromStub(GatewayProxyFactory.InvocationHandler<Future<R>> dispatcher, Object stubGateway) {
            this.dispatcher = dispatcher;
            this.stubGateway = stubGateway;
        }

        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            Future future = (Future)this.dispatcher.invoke(proxy, invokedMethod, args);
            if (this.stubGateway != null) {
                return (R)invokedMethod.invoke(this.stubGateway, args);
            }
            if (future.isDone()) {
                return (R)future.get();
            }
            return null;
        }
    }

    private static class StubAwareGatewayProxyFactory
    extends GatewayProxyFactory {
        private final Object stubImplementation;

        public StubAwareGatewayProxyFactory(Object stubImplementation, RecordingCommandBus commandBus) {
            super((CommandBus)commandBus, new MessageDispatchInterceptor[0]);
            this.stubImplementation = stubImplementation;
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToWaitForResult(GatewayProxyFactory.InvocationHandler<Future<R>> delegate) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToReturnWithFixedTimeout(GatewayProxyFactory.InvocationHandler<Future<R>> delegate, long timeout, TimeUnit timeUnit) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToReturnWithTimeoutInArguments(GatewayProxyFactory.InvocationHandler<Future<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }
    }
}

