/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.List;
import org.axonframework.domain.Message;
import org.axonframework.test.matchers.EmptyCollectionMatcher;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.ExactSequenceMatcher;
import org.axonframework.test.matchers.ListWithAllOfMatcher;
import org.axonframework.test.matchers.ListWithAnyOfMatcher;
import org.axonframework.test.matchers.NullOrVoidMatcher;
import org.axonframework.test.matchers.PayloadMatcher;
import org.axonframework.test.matchers.PayloadsMatcher;
import org.axonframework.test.matchers.SequenceMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class Matchers {
    private Matchers() {
    }

    public static Matcher<List<? extends Message<?>>> payloadsMatching(Matcher<? extends Iterable<?>> matcher) {
        return new PayloadsMatcher(matcher);
    }

    public static Matcher<Message> messageWithPayload(Matcher<?> payloadMatcher) {
        return new PayloadMatcher(payloadMatcher);
    }

    @Factory
    public static Matcher<List<?>> listWithAllOf(Matcher<?> ... matchers) {
        return new ListWithAllOfMatcher((Matcher[])matchers);
    }

    @Factory
    public static Matcher<List<?>> listWithAnyOf(Matcher<?> ... matchers) {
        return new ListWithAnyOfMatcher((Matcher[])matchers);
    }

    @Factory
    public static Matcher<List<?>> sequenceOf(Matcher<?> ... matchers) {
        return new SequenceMatcher(matchers);
    }

    @Factory
    public static Matcher<List<?>> exactSequenceOf(Matcher<?> ... matchers) {
        return new ExactSequenceMatcher(matchers);
    }

    @Factory
    public static Matcher<List<?>> noEvents() {
        return new EmptyCollectionMatcher("events");
    }

    @Factory
    public static Matcher<List<?>> noCommands() {
        return new EmptyCollectionMatcher("commands");
    }

    @Factory
    public static <T> EqualFieldsMatcher<T> equalTo(T expected) {
        return new EqualFieldsMatcher<T>(expected);
    }

    @Factory
    public static Matcher<?> andNoMore() {
        return Matchers.nothing();
    }

    @Factory
    public static Matcher<?> nothing() {
        return new NullOrVoidMatcher();
    }
}

