/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.Event;
import org.axonframework.domain.EventBase;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.Reporter;
import org.axonframework.test.ResultValidator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

class ResultValidatorImpl
implements ResultValidator,
CommandCallback<Object> {
    private final Collection<DomainEvent> storedEvents;
    private final Collection<Event> publishedEvents;
    private Object actualReturnValue;
    private Throwable actualException;
    private final Reporter reporter = new Reporter();

    public ResultValidatorImpl(Collection<DomainEvent> storedEvents, Collection<Event> publishedEvents) {
        this.storedEvents = storedEvents;
        this.publishedEvents = publishedEvents;
    }

    @Override
    public ResultValidator expectEvents(DomainEvent ... expectedEvents) {
        if (this.publishedEvents.size() != this.storedEvents.size()) {
            this.reporter.reportDifferenceInStoredVsPublished(this.storedEvents, this.publishedEvents, this.actualException);
        }
        return this.expectPublishedEvents((Event[])expectedEvents);
    }

    @Override
    public ResultValidator expectEvents(Matcher<List<? extends Event>> matcher) {
        if (this.publishedEvents.size() != this.storedEvents.size()) {
            this.reporter.reportDifferenceInStoredVsPublished(this.storedEvents, this.publishedEvents, this.actualException);
        }
        return this.expectPublishedEvents(matcher);
    }

    @Override
    public ResultValidator expectPublishedEvents(Event ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<Event> iterator = this.publishedEvents.iterator();
        for (Event expectedEvent : expectedEvents) {
            Event actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent)) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectPublishedEvents(Matcher<List<? extends Event>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            this.reporter.reportWrongEvent(this.publishedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    private StringDescription descriptionOf(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        return description;
    }

    @Override
    public ResultValidator expectStoredEvents(DomainEvent ... expectedEvents) {
        if (expectedEvents.length != this.storedEvents.size()) {
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<DomainEvent> iterator = this.storedEvents.iterator();
        for (DomainEvent expectedEvent : expectedEvents) {
            DomainEvent actualEvent = iterator.next();
            if (this.verifyEventEquality((Event)expectedEvent, (Event)actualEvent)) continue;
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectStoredEvents(Matcher<List<? extends DomainEvent>> matcher) {
        if (!matcher.matches(this.storedEvents)) {
            this.reporter.reportWrongEvent(this.storedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectVoidReturnType() {
        return this.expectReturnValue(Void.TYPE);
    }

    @Override
    public ResultValidator expectReturnValue(Object expectedReturnValue) {
        if (expectedReturnValue == null) {
            return this.expectReturnValue(CoreMatchers.nullValue());
        }
        return this.expectReturnValue(CoreMatchers.equalTo((Object)expectedReturnValue));
    }

    @Override
    public ResultValidator expectReturnValue(Matcher<?> matcher) {
        if (matcher == null) {
            return this.expectReturnValue(CoreMatchers.nullValue());
        }
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)description);
        } else if (!matcher.matches(this.actualReturnValue)) {
            this.reporter.reportWrongResult(this.actualReturnValue, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator expectException(Class<? extends Throwable> expectedException) {
        return this.expectException(CoreMatchers.instanceOf(expectedException));
    }

    @Override
    public ResultValidator expectException(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualReturnValue != null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue, (Description)description);
        }
        if (!matcher.matches((Object)this.actualException)) {
            this.reporter.reportWrongException(this.actualException, (Description)description);
        }
        return this;
    }

    public void onSuccess(Object result) {
        this.actualReturnValue = result;
    }

    public void onFailure(Throwable cause) {
        this.actualException = cause;
    }

    private boolean verifyEventEquality(Event expectedEvent, Event actualEvent) {
        if (!expectedEvent.getClass().equals(actualEvent.getClass())) {
            return false;
        }
        this.verifyEqualFields(expectedEvent.getClass(), expectedEvent, actualEvent);
        return true;
    }

    private void verifyEqualFields(Class<?> aClass, Event expectedEvent, Event actualEvent) {
        for (Field field : aClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object expected = field.get(expectedEvent);
                Object actual = field.get(actualEvent);
                if (expected != null && actual != null && expected.getClass().isArray()) {
                    if (Arrays.deepEquals(new Object[]{expected}, new Object[]{actual})) continue;
                    this.reporter.reportDifferentEventContents(expectedEvent.getClass(), field, actual, expected);
                    continue;
                }
                if ((expected == null || expected.equals(actual)) && (expected != null || actual == null)) continue;
                this.reporter.reportDifferentEventContents(expectedEvent.getClass(), field, actual, expected);
            }
            catch (IllegalAccessException e) {
                throw new FixtureExecutionException("Could not confirm event equality due to an exception", e);
            }
        }
        if (aClass.getSuperclass() != DomainEvent.class && aClass.getSuperclass() != EventBase.class && aClass.getSuperclass() != Object.class) {
            this.verifyEqualFields(aClass.getSuperclass(), expectedEvent, actualEvent);
        }
    }
}

