/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.Event;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericEventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.repository.AggregateNotFoundException;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.TestExecutor;
import org.junit.Assert;

class GivenWhenThenTestFixture
implements ResultValidator,
FixtureConfiguration,
TestExecutor {
    private EventSourcingRepository<?> repository;
    private CommandBus commandBus;
    private EventBus eventBus;
    private UUID aggregateIdentifier = UUID.randomUUID();
    private EventStore eventStore;
    private List<DomainEvent> givenEvents;
    private List<DomainEvent> storedEvents;
    private List<DomainEvent> publishedEvents;
    private Object actualReturnValue;
    private Throwable actualException;
    private long sequenceNumber = 0L;

    public GivenWhenThenTestFixture() {
        this.eventBus = new RecordingEventBus();
        this.commandBus = new SimpleCommandBus();
        this.eventStore = new RecordingEventStore();
        this.clearGivenWhenState();
    }

    @Override
    public FixtureConfiguration registerGenericRepository(Class<?> aggregateClass) {
        this.registerRepository((EventSourcingRepository<?>)new GenericEventSourcingRepository(aggregateClass));
        return this;
    }

    @Override
    public FixtureConfiguration registerRepository(EventSourcingRepository<?> repository) {
        this.repository = repository;
        repository.setEventBus(this.eventBus);
        repository.setEventStore(this.eventStore);
        return this;
    }

    @Override
    public GivenWhenThenTestFixture registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        AnnotationCommandHandlerAdapter commandHandlerAdapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, this.commandBus);
        commandHandlerAdapter.subscribe();
        return this;
    }

    @Override
    public FixtureConfiguration registerCommandHandler(Class<?> commandType, CommandHandler commandHandler) {
        this.commandBus.subscribe(commandType, commandHandler);
        return this;
    }

    @Override
    public TestExecutor given(DomainEvent ... domainEvents) {
        this.clearGivenWhenState();
        for (DomainEvent event : domainEvents) {
            this.setByReflection(DomainEvent.class, "aggregateIdentifier", event, this.aggregateIdentifier);
            this.setByReflection(DomainEvent.class, "sequenceNumber", event, this.sequenceNumber++);
        }
        this.givenEvents = Arrays.asList(domainEvents);
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        try {
            this.actualReturnValue = this.commandBus.dispatch(command);
        }
        catch (Exception ex) {
            this.actualException = ex;
        }
        return this;
    }

    private void clearGivenWhenState() {
        this.storedEvents = new ArrayList<DomainEvent>();
        this.publishedEvents = new ArrayList<DomainEvent>();
        this.givenEvents = new ArrayList<DomainEvent>();
        this.sequenceNumber = 0L;
        this.actualReturnValue = null;
        this.actualException = null;
    }

    @Override
    public ResultValidator expectEvents(DomainEvent ... expectedEvents) {
        Assert.assertEquals((long)this.publishedEvents.size(), (long)this.storedEvents.size());
        Assert.assertEquals((String)"Wrong number of events. ", (long)expectedEvents.length, (long)this.publishedEvents.size());
        Iterator<DomainEvent> iterator = this.publishedEvents.iterator();
        for (DomainEvent expectedEvent : expectedEvents) {
            Event actualEvent = (Event)iterator.next();
            this.verifyEventEquality(expectedEvent, actualEvent);
        }
        return this;
    }

    @Override
    public ResultValidator expectVoidReturnType() {
        return this.expectReturnValue(Void.TYPE);
    }

    @Override
    public ResultValidator expectReturnValue(Object expectedReturnValue) {
        if (this.actualException != null) {
            this.actualException.printStackTrace();
            Assert.fail((String)String.format("Expected return value (a %s), but got exception: %s", expectedReturnValue.getClass().getSimpleName(), this.actualException));
        }
        Assert.assertEquals((String)"Return value of command handler not as", (Object)expectedReturnValue, (Object)this.actualReturnValue);
        return this;
    }

    @Override
    public ResultValidator expectException(Class<? extends Throwable> expectedException) {
        if (this.actualReturnValue != null) {
            Assert.fail((String)String.format("Expected exception (%s), but got return value: %s", expectedException.getSimpleName(), this.actualReturnValue));
        }
        Assert.assertEquals(expectedException, this.actualException.getClass());
        return this;
    }

    UUID getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    private void verifyEventEquality(DomainEvent expectedEvent, Event actualEvent) {
        Assert.assertEquals((String)"Event of wrong type. ", (Object)expectedEvent.getClass().getName(), (Object)actualEvent.getClass().getName());
        this.verifyEqualFields(expectedEvent.getClass(), expectedEvent, actualEvent);
    }

    private void setByReflection(Class<?> eventClass, String fieldName, DomainEvent event, Object value) {
        try {
            Field field = eventClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(event, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Test fixture cannot do its work", e);
        }
    }

    private void verifyEqualFields(Class<?> aClass, DomainEvent expectedEvent, Event actualEvent) {
        for (Field field : aClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Assert.assertEquals((String)String.format("Field [%s] in event of type [%s],", aClass.getSimpleName() + "." + field.getName(), expectedEvent.getClass().getSimpleName()), (Object)field.get(expectedEvent), (Object)field.get(actualEvent));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (aClass.getSuperclass() != DomainEvent.class) {
            this.verifyEqualFields(aClass.getSuperclass(), expectedEvent, actualEvent);
        }
    }

    public EventSourcingRepository<?> getRepository() {
        return this.repository;
    }

    private class RecordingEventBus
    implements EventBus {
        private RecordingEventBus() {
        }

        public void publish(Event event) {
            GivenWhenThenTestFixture.this.publishedEvents.add((DomainEvent)event);
        }

        public void subscribe(EventListener eventListener) {
        }

        public void unsubscribe(EventListener eventListener) {
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public void appendEvents(String type, DomainEventStream events) {
            while (events.hasNext()) {
                DomainEvent next = events.next();
                GivenWhenThenTestFixture.this.storedEvents.add(next);
            }
        }

        public DomainEventStream readEvents(String type, UUID identifier) {
            if (!GivenWhenThenTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new AggregateNotFoundException("You probably want to use Fixtures.aggregateIdentifier() to get the aggregate identifier to load");
            }
            return new SimpleDomainEventStream(GivenWhenThenTestFixture.this.givenEvents);
        }
    }
}

