/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.util.UUID;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.repository.Repository;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.GivenWhenThenTestFixture;

public abstract class Fixtures {
    private static final ThreadLocal<GivenWhenThenTestFixture> currentFixture = new ThreadLocal();

    public static FixtureConfiguration givenWhenThenFixture() {
        return Fixtures.getCurrentFixture();
    }

    public static <T extends AggregateRoot> Repository<T> genericRepository(Class<T> aggregateType) {
        GivenWhenThenTestFixture fixture = Fixtures.getCurrentFixture();
        fixture.registerGenericRepository(aggregateType);
        return fixture.getRepository();
    }

    public static Repository<? extends AggregateRoot> getRepository() {
        return Fixtures.getCurrentFixture().getRepository();
    }

    public static UUID aggregateIdentifier() {
        return Fixtures.getCurrentFixture().getAggregateIdentifier();
    }

    private static GivenWhenThenTestFixture getCurrentFixture() {
        GivenWhenThenTestFixture fixture = currentFixture.get();
        if (fixture == null) {
            fixture = new GivenWhenThenTestFixture();
            currentFixture.set(fixture);
        }
        return fixture;
    }
}

