/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.spring.messaging.EventMessageConverter;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.NumberUtils;

public class DefaultEventMessageConverter
implements EventMessageConverter {
    private static final String AXON_MESSAGE_PREFIX = "axon-message-";
    private static final String MESSAGE_ID = "axon-message-id";
    private static final String MESSAGE_TYPE = "axon-message-type";
    private static final String AGGREGATE_ID = "axon-message-aggregate-id";
    private static final String AGGREGATE_SEQ = "axon-message-aggregate-seq";
    private static final String AGGREGATE_TYPE = "axon-message-aggregate-type";

    @Override
    public <T> org.springframework.messaging.Message<T> convertToOutboundMessage(EventMessage<T> event) {
        HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)event.getMetaData());
        headers.put(MESSAGE_ID, event.getIdentifier());
        headers.put(MESSAGE_TYPE, event.type().toString());
        if (event instanceof DomainEventMessage) {
            headers.put(AGGREGATE_ID, ((DomainEventMessage)event).getAggregateIdentifier());
            headers.put(AGGREGATE_SEQ, ((DomainEventMessage)event).getSequenceNumber());
            headers.put(AGGREGATE_TYPE, ((DomainEventMessage)event).getType());
        }
        return new org.springframework.messaging.support.GenericMessage(event.getPayload(), (MessageHeaders)new SettableTimestampMessageHeaders(headers, event.getTimestamp().toEpochMilli()));
    }

    @Override
    public <T> EventMessage<T> convertFromInboundMessage(org.springframework.messaging.Message<T> message) {
        MessageHeaders headers = message.getHeaders();
        Map<String, String> metaData = headers.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(AXON_MESSAGE_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        String messageId = Objects.toString(headers.get((Object)MESSAGE_ID));
        MessageType type = DefaultEventMessageConverter.getType(message);
        Long timestamp = headers.getTimestamp();
        GenericMessage genericMessage = new GenericMessage(messageId, type, message.getPayload(), metaData);
        if (headers.containsKey((Object)AGGREGATE_ID)) {
            return new GenericDomainEventMessage(Objects.toString(headers.get((Object)AGGREGATE_TYPE)), Objects.toString(headers.get((Object)AGGREGATE_ID)), ((Long)NumberUtils.convertNumberToTargetClass((Number)((Number)headers.get((Object)AGGREGATE_SEQ, Number.class)), Long.class)).longValue(), (Message)genericMessage, () -> Instant.ofEpochMilli(timestamp));
        }
        return new GenericEventMessage((Message)genericMessage, () -> Instant.ofEpochMilli(timestamp));
    }

    private static <T> MessageType getType(org.springframework.messaging.Message<T> message) {
        MessageHeaders headers = message.getHeaders();
        return headers.containsKey((Object)MESSAGE_TYPE) ? MessageType.fromString((String)Objects.toString(headers.get((Object)MESSAGE_TYPE))) : new MessageType(message.getClass());
    }

    private static class SettableTimestampMessageHeaders
    extends MessageHeaders {
        protected SettableTimestampMessageHeaders(Map<String, Object> headers, Long timestamp) {
            super(headers, null, timestamp);
        }
    }
}

