/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.common.annotation.Internal;
import org.springframework.context.SmartLifecycle;

@Internal
public class SpringLifecycleStartHandler
implements SmartLifecycle {
    private final int phase;
    private final Supplier<CompletableFuture<?>> task;
    private final AtomicBoolean running = new AtomicBoolean(false);

    SpringLifecycleStartHandler(int phase, @Nonnull Supplier<CompletableFuture<?>> task) {
        this.phase = phase;
        this.task = task;
    }

    public void start() {
        try {
            ((CompletableFuture)this.task.get().whenComplete((result, throwable) -> this.running.set(true))).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    public void stop() {
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return this.phase;
    }
}

