/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.util.Set;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.LegacyGenericJpaRepository;
import org.axonframework.modelling.command.LegacyRepository;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAggregateConfigurer<T>
implements ConfigurerModule,
ApplicationContextAware {
    private final Class<T> aggregateType;
    private final Set<Class<? extends T>> subTypes;
    private String snapshotFilter;
    private String aggregateRepository;
    private String snapshotTriggerDefinition;
    private String cache;
    private String lockFactory;
    private String commandTargetResolver;
    private boolean filterEventsByType;
    private ApplicationContext applicationContext;
    private String aggregateFactory;

    public SpringAggregateConfigurer(Class<T> aggregateType, Set<Class<? extends T>> subTypes) {
        this.aggregateType = aggregateType;
        this.subTypes = subTypes;
    }

    public void setRepository(String aggregateRepository) {
        this.aggregateRepository = aggregateRepository;
    }

    public void setSnapshotFilter(String snapshotFilter) {
        this.snapshotFilter = snapshotFilter;
    }

    public void setSnapshotTriggerDefinition(String snapshotTriggerDefinition) {
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
    }

    public void setCommandTargetResolver(String commandTargetResolver) {
        this.commandTargetResolver = commandTargetResolver;
    }

    public void setFilterEventsByType(boolean filterEventsByType) {
        this.filterEventsByType = filterEventsByType;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public void setLockFactory(String lockFactory) {
        this.lockFactory = lockFactory;
    }

    public void setAggregateFactory(String aggregateFactory) {
        this.aggregateFactory = aggregateFactory;
    }

    public void configureModule(@Nonnull LegacyConfigurer configurer) {
        AggregateConfigurer aggregateConfigurer = AggregateConfigurer.defaultConfiguration(this.aggregateType).withSubtypes(this.subTypes);
        if (this.snapshotFilter != null) {
            aggregateConfigurer.configureSnapshotFilter(c -> (SnapshotFilter)this.applicationContext.getBean(this.snapshotFilter, SnapshotFilter.class));
        }
        if (this.aggregateRepository != null) {
            aggregateConfigurer.configureRepository(c -> (LegacyRepository)this.applicationContext.getBean(this.aggregateRepository, LegacyRepository.class));
        } else if (this.isEntityManagerAnnotationPresent(this.aggregateType)) {
            aggregateConfigurer.configureRepository(c -> LegacyGenericJpaRepository.builder(this.aggregateType).parameterResolverFactory(c.parameterResolverFactory()).handlerDefinition(c.handlerDefinition(this.aggregateType)).lockFactory((LockFactory)c.getComponent(LockFactory.class, () -> NullLockFactory.INSTANCE)).entityManagerProvider((EntityManagerProvider)c.getComponent(EntityManagerProvider.class)).eventBus(c.eventBus()).repositoryProvider(arg_0 -> ((LegacyConfiguration)c).repository(arg_0)).spanFactory((RepositorySpanFactory)c.getComponent(RepositorySpanFactory.class)).build());
        }
        if (this.snapshotTriggerDefinition != null) {
            aggregateConfigurer.configureSnapshotTrigger(c -> (SnapshotTriggerDefinition)this.applicationContext.getBean(this.snapshotTriggerDefinition, SnapshotTriggerDefinition.class));
        }
        if (this.commandTargetResolver != null) {
            aggregateConfigurer.configureCommandTargetResolver(c -> (CommandTargetResolver)this.applicationContext.getBean(this.commandTargetResolver, CommandTargetResolver.class));
        }
        if (this.cache != null) {
            aggregateConfigurer.configureCache(c -> (Cache)this.applicationContext.getBean(this.cache, Cache.class));
        }
        if (this.lockFactory != null) {
            aggregateConfigurer.configureLockFactory(c -> (LockFactory)this.applicationContext.getBean(this.lockFactory, LockFactory.class));
        }
        if (this.aggregateFactory != null) {
            aggregateConfigurer.configureAggregateFactory(c -> (AggregateFactory)this.applicationContext.getBean(this.aggregateFactory, AggregateFactory.class));
        }
        aggregateConfigurer.configureFilterEventsByType(c -> this.filterEventsByType);
        configurer.configureAggregate((AggregateConfiguration)aggregateConfigurer);
    }

    private boolean isEntityManagerAnnotationPresent(Class<T> type) {
        return AnnotationUtils.isAnnotationPresent(type, (String)"javax.persistence.Entity") || AnnotationUtils.isAnnotationPresent(type, (String)"jakarta.persistence.Entity");
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

