/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class MessageAuthorizationDispatchInterceptor<T extends Message<?>>
implements MessageDispatchInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageAuthorizationDispatchInterceptor.class);
    private final Converter converter;

    public MessageAuthorizationDispatchInterceptor(@Nonnull Converter converter) {
        this.converter = Objects.requireNonNull(converter, "Converter must not be null.");
    }

    @Nonnull
    public T handle(@Nonnull T message) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("No authentication found.");
            return message;
        }
        logger.debug("Adding message metadata for username & authorities.");
        HashMap<String, String> authenticationDetails = new HashMap<String, String>();
        authenticationDetails.put("username", (String)this.converter.convert(authentication.getPrincipal(), String.class));
        String authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        authenticationDetails.put("authorities", authorities);
        return (T)message.andMetaData(authenticationDetails);
    }

    @Nonnull
    public BiFunction<Integer, T, T> handle(@Nonnull List<? extends T> list) {
        return (position, message) -> this.handle(message);
    }
}

