/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Set;
import javax.annotation.Nonnull;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.Repository;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAggregateConfigurer<T>
implements ConfigurerModule,
ApplicationContextAware {
    private final Class<T> aggregateType;
    private final Set<Class<? extends T>> subTypes;
    private String snapshotFilter;
    private String aggregateRepository;
    private String snapshotTriggerDefinition;
    private String cache;
    private String lockFactory;
    private String commandTargetResolver;
    private boolean filterEventsByType;
    private ApplicationContext applicationContext;
    private String aggregateFactory;

    public SpringAggregateConfigurer(Class<T> aggregateType, Set<Class<? extends T>> subTypes) {
        this.aggregateType = aggregateType;
        this.subTypes = subTypes;
    }

    public void setRepository(String aggregateRepository) {
        this.aggregateRepository = aggregateRepository;
    }

    public void setSnapshotFilter(String snapshotFilter) {
        this.snapshotFilter = snapshotFilter;
    }

    public void setSnapshotTriggerDefinition(String snapshotTriggerDefinition) {
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
    }

    public void setCommandTargetResolver(String commandTargetResolver) {
        this.commandTargetResolver = commandTargetResolver;
    }

    public void setFilterEventsByType(boolean filterEventsByType) {
        this.filterEventsByType = filterEventsByType;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public void setLockFactory(String lockFactory) {
        this.lockFactory = lockFactory;
    }

    public void setAggregateFactory(String aggregateFactory) {
        this.aggregateFactory = aggregateFactory;
    }

    public void configureModule(@Nonnull Configurer configurer) {
        AggregateConfigurer aggregateConfigurer = AggregateConfigurer.defaultConfiguration(this.aggregateType).withSubtypes(this.subTypes);
        if (this.snapshotFilter != null) {
            aggregateConfigurer.configureSnapshotFilter(c -> (SnapshotFilter)this.applicationContext.getBean(this.snapshotFilter, SnapshotFilter.class));
        }
        if (this.aggregateRepository != null) {
            aggregateConfigurer.configureRepository(c -> (Repository)this.applicationContext.getBean(this.aggregateRepository, Repository.class));
        }
        if (this.snapshotTriggerDefinition != null) {
            aggregateConfigurer.configureSnapshotTrigger(c -> (SnapshotTriggerDefinition)this.applicationContext.getBean(this.snapshotTriggerDefinition, SnapshotTriggerDefinition.class));
        }
        if (this.commandTargetResolver != null) {
            aggregateConfigurer.configureCommandTargetResolver(c -> (CommandTargetResolver)this.applicationContext.getBean(this.commandTargetResolver, CommandTargetResolver.class));
        }
        if (this.cache != null) {
            aggregateConfigurer.configureCache(c -> (Cache)this.applicationContext.getBean(this.cache, Cache.class));
        }
        if (this.lockFactory != null) {
            aggregateConfigurer.configureLockFactory(c -> (LockFactory)this.applicationContext.getBean(this.lockFactory, LockFactory.class));
        }
        if (this.aggregateFactory != null) {
            aggregateConfigurer.configureAggregateFactory(c -> (AggregateFactory)this.applicationContext.getBean(this.aggregateFactory, AggregateFactory.class));
        }
        aggregateConfigurer.configureFilterEventsByType(c -> this.filterEventsByType);
        configurer.configureAggregate((AggregateConfiguration)aggregateConfigurer);
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

