/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Collection;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessageHandler;
import org.axonframework.messaging.MessageHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public class CommandHandlerSubscriber
implements ApplicationContextAware,
SmartLifecycle {
    private ApplicationContext applicationContext;
    private boolean started;
    private Collection<MessageHandler> commandHandlers;
    private CommandBus commandBus;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCommandBus(CommandBus commandBus) {
        this.commandBus = commandBus;
    }

    public void setCommandHandlers(Collection<MessageHandler> commandHandlers) {
        this.commandHandlers = commandHandlers;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.commandBus == null && !this.applicationContext.getBeansOfType(CommandBus.class).isEmpty()) {
            this.commandBus = (CommandBus)this.applicationContext.getBean(CommandBus.class);
        }
        if (this.commandHandlers == null) {
            this.commandHandlers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MessageHandler.class).values();
        }
        this.commandHandlers.stream().filter(commandHandler -> commandHandler instanceof CommandMessageHandler).forEach(commandHandler -> {
            for (String commandName : ((CommandMessageHandler)commandHandler).supportedCommandNames()) {
                this.commandBus.subscribe(commandName, commandHandler);
            }
        });
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public int getPhase() {
        return -1073741824;
    }
}

