/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.model.GenericJpaRepository;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.SpringUtils;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.CommandHandlerSubscriber;
import org.axonframework.spring.config.EventHandlerRegistrar;
import org.axonframework.spring.config.QueryHandlerSubscriber;
import org.axonframework.spring.config.RepositoryFactoryBean;
import org.axonframework.spring.config.annotation.SpringContextHandlerDefinitionBuilder;
import org.axonframework.spring.config.annotation.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.spring.eventsourcing.SpringPrototypeAggregateFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.axonframework.spring.saga.SpringResourceInjector;
import org.axonframework.spring.stereotype.Aggregate;
import org.axonframework.spring.stereotype.Saga;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringAxonAutoConfigurer
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    public static final String AXON_CONFIGURATION_BEAN = "org.axonframework.spring.config.AxonConfiguration";
    public static final String AXON_CONFIGURER_BEAN = "org.axonframework.config.Configurer";
    private static final Logger logger = LoggerFactory.getLogger(SpringAxonAutoConfigurer.class);
    private ConfigurableListableBeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition("commandHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(CommandHandlerSubscriber.class).getBeanDefinition());
        registry.registerBeanDefinition("queryHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(QueryHandlerSubscriber.class).getBeanDefinition());
        Configurer configurer = DefaultConfigurer.defaultConfiguration();
        RuntimeBeanReference parameterResolver = SpringContextParameterResolverFactoryBuilder.getBeanReference(registry);
        configurer.registerComponent(ParameterResolverFactory.class, c -> (ParameterResolverFactory)this.beanFactory.getBean(parameterResolver.getBeanName(), ParameterResolverFactory.class));
        RuntimeBeanReference handlerDefinition = SpringContextHandlerDefinitionBuilder.getBeanReference(registry);
        configurer.registerHandlerDefinition((c, clazz) -> (HandlerDefinition)this.beanFactory.getBean(handlerDefinition.getBeanName(), HandlerDefinition.class));
        this.findComponent(CommandBus.class).ifPresent(commandBus -> configurer.configureCommandBus(c -> (CommandBus)this.getBean((String)commandBus, (Configuration)c)));
        this.findComponent(QueryBus.class).ifPresent(queryBus -> configurer.configureQueryBus(c -> (QueryBus)this.getBean((String)queryBus, (Configuration)c)));
        this.findComponent(QueryUpdateEmitter.class).ifPresent(queryUpdateEmitter -> configurer.configureQueryUpdateEmitter(c -> (QueryUpdateEmitter)this.getBean((String)queryUpdateEmitter, (Configuration)c)));
        this.findComponent(EventStorageEngine.class).ifPresent(ese -> configurer.configureEmbeddedEventStore(c -> (EventStorageEngine)this.getBean((String)ese, (Configuration)c)));
        this.findComponent(EventBus.class).ifPresent(eventBus -> configurer.configureEventBus(c -> (EventBus)this.getBean((String)eventBus, (Configuration)c)));
        this.findComponent(Serializer.class).ifPresent(serializer -> configurer.configureSerializer(c -> (Serializer)this.getBean((String)serializer, (Configuration)c)));
        this.findComponent(Serializer.class, "eventSerializer").ifPresent(eventSerializer -> configurer.configureEventSerializer(c -> (Serializer)this.getBean((String)eventSerializer, (Configuration)c)));
        this.findComponent(Serializer.class, "messageSerializer").ifPresent(messageSerializer -> configurer.configureMessageSerializer(c -> (Serializer)this.getBean((String)messageSerializer, (Configuration)c)));
        this.findComponent(TokenStore.class).ifPresent(tokenStore -> configurer.registerComponent(TokenStore.class, c -> (TokenStore)this.getBean((String)tokenStore, (Configuration)c)));
        try {
            this.findComponent(PlatformTransactionManager.class).ifPresent(ptm -> configurer.configureTransactionManager(c -> new SpringTransactionManager((PlatformTransactionManager)this.getBean((String)ptm, (Configuration)c))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.findComponent(TransactionManager.class).ifPresent(tm -> configurer.configureTransactionManager(c -> (TransactionManager)this.getBean((String)tm, (Configuration)c)));
        this.findComponent(SagaStore.class).ifPresent(sagaStore -> configurer.registerComponent(SagaStore.class, c -> (SagaStore)this.getBean((String)sagaStore, (Configuration)c)));
        this.findComponent(ListenerInvocationErrorHandler.class).ifPresent(handler -> configurer.registerComponent(ListenerInvocationErrorHandler.class, c -> (ListenerInvocationErrorHandler)this.getBean((String)handler, (Configuration)c)));
        this.findComponent(ErrorHandler.class).ifPresent(handler -> configurer.registerComponent(ErrorHandler.class, c -> (ErrorHandler)this.getBean((String)handler, (Configuration)c)));
        String resourceInjector = this.findComponent(ResourceInjector.class, registry, () -> BeanDefinitionBuilder.genericBeanDefinition(SpringResourceInjector.class).getBeanDefinition());
        configurer.configureResourceInjector(c -> (ResourceInjector)this.getBean(resourceInjector, (Configuration)c));
        this.findComponent(DeadlineManager.class).ifPresent(deadlineManager -> configurer.registerComponent(DeadlineManager.class, c -> (DeadlineManager)this.getBean((String)deadlineManager, (Configuration)c)));
        Optional<String> eventHandlingConfiguration = this.findComponent(EventHandlingConfiguration.class);
        String ehConfigBeanName = eventHandlingConfiguration.orElse("eventHandlingConfiguration");
        if (!eventHandlingConfiguration.isPresent()) {
            registry.registerBeanDefinition(ehConfigBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventHandlingConfiguration.class).getBeanDefinition());
        }
        Optional<String> eventProcessingConfiguration = this.findComponent(EventProcessingConfiguration.class);
        String eventProcessorRegistryBeanName = eventProcessingConfiguration.orElse("eventProcessingConfiguration");
        if (!eventProcessingConfiguration.isPresent()) {
            registry.registerBeanDefinition(eventProcessorRegistryBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventProcessingConfiguration.class).getBeanDefinition());
        }
        this.registerModules(configurer);
        this.registerCorrelationDataProviders(configurer);
        this.registerEventUpcasters(configurer);
        this.registerAggregateBeanDefinitions(configurer, registry);
        this.registerSagaBeanDefinitions(configurer);
        this.beanFactory.registerSingleton(AXON_CONFIGURER_BEAN, (Object)configurer);
        registry.registerBeanDefinition(AXON_CONFIGURATION_BEAN, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(AxonConfiguration.class).addConstructorArgReference(AXON_CONFIGURER_BEAN).getBeanDefinition());
        this.registerEventHandlerRegistrar(ehConfigBeanName, registry);
    }

    private void registerCorrelationDataProviders(Configurer configurer) {
        configurer.configureCorrelationDataProviders(c -> {
            String[] correlationDataProviderBeans = this.beanFactory.getBeanNamesForType(CorrelationDataProvider.class);
            return Arrays.stream(correlationDataProviderBeans).map(n -> (CorrelationDataProvider)this.getBean((String)n, (Configuration)c)).collect(Collectors.toList());
        });
    }

    private void registerEventUpcasters(Configurer configurer) {
        Arrays.stream(this.beanFactory.getBeanNamesForType(EventUpcaster.class)).forEach(name -> configurer.registerEventUpcaster(c -> (EventUpcaster)this.getBean((String)name, (Configuration)c)));
    }

    private <T> T getBean(String beanName, Configuration configuration) {
        return (T)((ApplicationContext)configuration.getComponent(ApplicationContext.class)).getBean(beanName);
    }

    private void registerEventHandlerRegistrar(String ehConfigBeanName, BeanDefinitionRegistry registry) {
        ManagedList beans = new ManagedList();
        this.beanFactory.getBeanNamesIterator().forEachRemaining(arg_0 -> this.lambda$registerEventHandlerRegistrar$40((List)beans, arg_0));
        registry.registerBeanDefinition("eventHandlerRegistrar", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventHandlerRegistrar.class).addConstructorArgReference(AXON_CONFIGURATION_BEAN).addConstructorArgReference(ehConfigBeanName).addPropertyValue("eventHandlers", (Object)beans).getBeanDefinition());
    }

    private void registerModules(Configurer configurer) {
        this.registerConfigurerModules(configurer);
        this.registerModuleConfigurations(configurer);
    }

    private void registerConfigurerModules(Configurer configurer) {
        String[] configurerModules;
        for (String configurerModuleBeanName : configurerModules = this.beanFactory.getBeanNamesForType(ConfigurerModule.class)) {
            ConfigurerModule configurerModule = (ConfigurerModule)this.beanFactory.getBean(configurerModuleBeanName, ConfigurerModule.class);
            configurerModule.configureModule(configurer);
        }
    }

    private void registerModuleConfigurations(Configurer configurer) {
        String[] moduleConfigurations;
        for (String moduleConfiguration : moduleConfigurations = this.beanFactory.getBeanNamesForType(ModuleConfiguration.class)) {
            configurer.registerModule((ModuleConfiguration)new LazyRetrievedModuleConfiguration(() -> (ModuleConfiguration)this.beanFactory.getBean(moduleConfiguration, ModuleConfiguration.class)));
        }
    }

    private void registerSagaBeanDefinitions(Configurer configurer) {
        String[] sagas;
        for (String saga : sagas = this.beanFactory.getBeanNamesForAnnotation(Saga.class)) {
            String configName;
            Saga sagaAnnotation = (Saga)this.beanFactory.findAnnotationOnBean(saga, Saga.class);
            Class sagaType = this.beanFactory.getType(saga);
            boolean explicitSagaConfig = !"".equals(sagaAnnotation.configurationBean());
            String string = configName = explicitSagaConfig ? sagaAnnotation.configurationBean() : this.lcFirst(sagaType.getSimpleName()) + "Configuration";
            if (explicitSagaConfig || this.beanFactory.containsBean(configName)) continue;
            SagaConfiguration sagaConfiguration = SagaConfiguration.subscribingSagaManager((Class)sagaType);
            this.beanFactory.registerSingleton(configName, (Object)sagaConfiguration);
            if (!"".equals(sagaAnnotation.sagaStore())) {
                sagaConfiguration.configureSagaStore(c -> (SagaStore)this.beanFactory.getBean(sagaAnnotation.sagaStore(), SagaStore.class));
            }
            configurer.registerModule((ModuleConfiguration)sagaConfiguration);
        }
    }

    private void registerAggregateBeanDefinitions(Configurer configurer, BeanDefinitionRegistry registry) {
        String[] aggregates;
        for (String aggregate : aggregates = this.beanFactory.getBeanNamesForAnnotation(Aggregate.class)) {
            Aggregate aggregateAnnotation = (Aggregate)this.beanFactory.findAnnotationOnBean(aggregate, Aggregate.class);
            Class aggregateType = this.beanFactory.getType(aggregate);
            AggregateConfigurer aggregateConf = AggregateConfigurer.defaultConfiguration((Class)aggregateType);
            if ("".equals(aggregateAnnotation.repository())) {
                String repositoryName = this.lcFirst(aggregateType.getSimpleName()) + "Repository";
                String factoryName = aggregate.substring(0, 1).toLowerCase() + aggregate.substring(1) + "AggregateFactory";
                if (this.beanFactory.containsBean(repositoryName)) {
                    aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(repositoryName, Repository.class));
                } else {
                    registry.registerBeanDefinition(repositoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RepositoryFactoryBean.class).addConstructorArgValue((Object)aggregateConf).getBeanDefinition());
                    if (!registry.isBeanNameInUse(factoryName)) {
                        registry.registerBeanDefinition(factoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringPrototypeAggregateFactory.class).addPropertyValue("prototypeBeanName", (Object)aggregate).getBeanDefinition());
                    }
                    aggregateConf.configureAggregateFactory(c -> (AggregateFactory)this.beanFactory.getBean(factoryName, AggregateFactory.class));
                    String triggerDefinition = aggregateAnnotation.snapshotTriggerDefinition();
                    if (!"".equals(triggerDefinition)) {
                        aggregateConf.configureSnapshotTrigger(c -> (SnapshotTriggerDefinition)this.beanFactory.getBean(triggerDefinition, SnapshotTriggerDefinition.class));
                    }
                    if (AnnotationUtils.isAnnotationPresent((AnnotatedElement)aggregateType, (String)"javax.persistence.Entity")) {
                        aggregateConf.configureRepository(c -> new GenericJpaRepository((EntityManagerProvider)c.getComponent(EntityManagerProvider.class, () -> (EntityManagerProvider)this.beanFactory.getBean(EntityManagerProvider.class)), aggregateType, c.eventBus(), arg_0 -> ((Configuration)c).repository(arg_0), (LockFactory)c.getComponent(LockFactory.class, () -> NullLockFactory.INSTANCE), c.parameterResolverFactory(), c.handlerDefinition(aggregateType)));
                    }
                }
            } else {
                aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(aggregateAnnotation.repository(), Repository.class));
            }
            if (!"".equals(aggregateAnnotation.commandTargetResolver())) {
                aggregateConf.configureCommandTargetResolver(c -> (CommandTargetResolver)this.getBean(aggregateAnnotation.commandTargetResolver(), (Configuration)c));
            } else {
                this.findComponent(CommandTargetResolver.class).ifPresent(commandTargetResolver -> aggregateConf.configureCommandTargetResolver(c -> (CommandTargetResolver)this.getBean((String)commandTargetResolver, (Configuration)c)));
            }
            configurer.configureAggregate((AggregateConfiguration)aggregateConf);
        }
    }

    private String lcFirst(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private <T> String findComponent(Class<T> componentType, BeanDefinitionRegistry registry, Supplier<BeanDefinition> defaultBean) {
        return this.findComponent(componentType).orElseGet(() -> {
            BeanDefinition beanDefinition = (BeanDefinition)defaultBean.get();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            registry.registerBeanDefinition(beanName, beanDefinition);
            return beanName;
        });
    }

    private <T> Optional<String> findComponent(Class<T> componentType, String componentQualifier) {
        return Stream.of(this.beanFactory.getBeanNamesForType(componentType)).filter(bean -> SpringUtils.isQualifierMatch(bean, this.beanFactory, componentQualifier)).findFirst();
    }

    private <T> Optional<String> findComponent(Class<T> componentType) {
        String[] beans = this.beanFactory.getBeanNamesForType(componentType);
        if (beans.length == 1) {
            return Optional.of(beans[0]);
        }
        if (beans.length > 1) {
            for (String bean : beans) {
                BeanDefinition beanDef = this.beanFactory.getBeanDefinition(bean);
                if (!beanDef.isPrimary()) continue;
                return Optional.of(bean);
            }
            logger.warn("Multiple beans of type {} found in application context: {}. Chose {}", new Object[]{componentType.getSimpleName(), beans, beans[0]});
            return Optional.of(beans[0]);
        }
        return Optional.empty();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private /* synthetic */ void lambda$registerEventHandlerRegistrar$40(List beans, String bean) {
        boolean hasHandler;
        Class beanType;
        if (!this.beanFactory.isFactoryBean(bean) && (beanType = this.beanFactory.getType(bean)) != null && this.beanFactory.containsBeanDefinition(bean) && this.beanFactory.getBeanDefinition(bean).isSingleton() && (hasHandler = StreamSupport.stream(ReflectionUtils.methodsOf((Class)beanType).spliterator(), false).map(m -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class).orElse(null)).filter(Objects::nonNull).anyMatch(attr -> EventMessage.class.isAssignableFrom((Class)attr.get("messageType"))))) {
            beans.add(new RuntimeBeanReference(bean));
        }
    }

    private static class LazyRetrievedModuleConfiguration
    implements ModuleConfiguration {
        private final Supplier<ModuleConfiguration> delegateSupplier;
        private ModuleConfiguration delegate;

        LazyRetrievedModuleConfiguration(Supplier<ModuleConfiguration> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
        }

        public void initialize(Configuration config) {
            this.getDelegate().initialize(config);
        }

        public void start() {
            this.getDelegate().start();
        }

        public void shutdown() {
            this.getDelegate().shutdown();
        }

        public int phase() {
            return this.getDelegate().phase();
        }

        public ModuleConfiguration unwrap() {
            return this.getDelegate();
        }

        private ModuleConfiguration getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.delegateSupplier.get();
            }
            return this.delegate;
        }
    }

    public static class ImportSelector
    implements DeferredImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{SpringAxonAutoConfigurer.class.getName()};
        }
    }
}

