/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Collection;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandlerAdapter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public class QueryHandlerSubscriber
implements ApplicationContextAware,
SmartLifecycle {
    private ApplicationContext applicationContext;
    private boolean started;
    private Collection<QueryHandlerAdapter> queryHandlers;
    private QueryBus queryBus;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setQueryHandlers(Collection<QueryHandlerAdapter> queryHandlers) {
        this.queryHandlers = queryHandlers;
    }

    public void setQueryBus(QueryBus queryBus) {
        this.queryBus = queryBus;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public void start() {
        if (this.queryBus == null && !this.applicationContext.getBeansOfType(QueryBus.class).isEmpty()) {
            this.queryBus = (QueryBus)this.applicationContext.getBean(QueryBus.class);
        }
        if (this.queryHandlers == null) {
            this.queryHandlers = this.applicationContext.getBeansOfType(QueryHandlerAdapter.class).values();
        }
        this.queryHandlers.forEach(queryHandler -> queryHandler.subscribe(this.queryBus));
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public int getPhase() {
        return -1073741824;
    }
}

