/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SupportedCommandNamesAware;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.config.AbstractAnnotationHandlerBeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class AnnotationCommandHandlerBeanPostProcessor
extends AbstractAnnotationHandlerBeanPostProcessor<MessageHandler<CommandMessage<?>>, AnnotationCommandHandlerAdapter> {
    @Override
    protected Class<?>[] getAdapterInterfaces() {
        return new Class[]{MessageHandler.class, SupportedCommandNamesAware.class};
    }

    @Override
    protected boolean isPostProcessingCandidate(Class<?> targetClass) {
        return this.hasCommandHandlerMethod(targetClass);
    }

    @Override
    protected AnnotationCommandHandlerAdapter initializeAdapterFor(Object bean, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return new AnnotationCommandHandlerAdapter(bean, parameterResolverFactory, handlerDefinition);
    }

    private boolean hasCommandHandlerMethod(Class<?> beanClass) {
        AtomicBoolean result = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new HasCommandHandlerAnnotationMethodCallback(result));
        return result.get();
    }

    private static final class HasCommandHandlerAnnotationMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final AtomicBoolean result;

        private HasCommandHandlerAnnotationMethodCallback(AtomicBoolean result) {
            this.result = result;
        }

        public void doWith(Method method) throws IllegalArgumentException {
            if (AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, CommandHandler.class).isPresent()) {
                this.result.set(true);
            }
        }
    }
}

