/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.SubscribableMessageSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;

public class ApplicationContextEventPublisher
implements InitializingBean,
ApplicationContextAware {
    private final SubscribableMessageSource<? extends EventMessage<?>> messageSource;
    private ApplicationContext applicationContext;

    public ApplicationContextEventPublisher(SubscribableMessageSource<? extends EventMessage<?>> messageSource) {
        this.messageSource = messageSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationEvent convert(EventMessage<?> eventMessage) {
        return new PayloadApplicationEvent(this.messageSource, eventMessage.getPayload());
    }

    public void afterPropertiesSet() throws Exception {
        this.messageSource.subscribe(msgs -> msgs.forEach(msg -> {
            ApplicationEvent converted = this.convert((EventMessage<?>)msg);
            if (converted != null) {
                this.applicationContext.publishEvent(this.convert((EventMessage<?>)msg));
            }
        }));
    }
}

