/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.Map;
import java.util.concurrent.Executor;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.config.annotation.SpringBeanParameterResolverFactory;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringAggregateSnapshotterFactoryBean
implements FactoryBean<SpringAggregateSnapshotter>,
ApplicationContextAware {
    private final Executor executor = DirectExecutor.INSTANCE;
    private PlatformTransactionManager transactionManager;
    private ApplicationContext applicationContext;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private EventStore eventStore;
    private ParameterResolverFactory parameterResolverFactory;

    public SpringAggregateSnapshotter getObject() throws Exception {
        Map candidates;
        if (this.transactionManager == null && (candidates = this.applicationContext.getBeansOfType(PlatformTransactionManager.class)).size() == 1) {
            this.transactionManager = (PlatformTransactionManager)candidates.values().iterator().next();
        }
        if (this.eventStore == null) {
            this.eventStore = (EventStore)this.applicationContext.getBean(EventStore.class);
        }
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getObjectType()), new SpringBeanParameterResolverFactory(this.applicationContext)});
        }
        Object txManager = this.transactionManager == null ? NoTransactionManager.INSTANCE : new SpringTransactionManager(this.transactionManager, this.transactionDefinition);
        SpringAggregateSnapshotter snapshotter = new SpringAggregateSnapshotter(this.eventStore, this.parameterResolverFactory, this.executor, (TransactionManager)txManager);
        snapshotter.setApplicationContext(this.applicationContext);
        return snapshotter;
    }

    public Class<?> getObjectType() {
        return AggregateSnapshotter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setEventStore(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

