/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.serialization.Serializer;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.CommandHandlerSubscriber;
import org.axonframework.spring.config.EventHandlerRegistrar;
import org.axonframework.spring.config.annotation.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.spring.eventsourcing.SpringPrototypeAggregateFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.axonframework.spring.saga.SpringResourceInjector;
import org.axonframework.spring.stereotype.Aggregate;
import org.axonframework.spring.stereotype.Saga;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringAxonAutoConfigurer
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    public static final String AXON_CONFIGURATION_BEAN = "org.axonframework.spring.config.AxonConfiguration";
    private static final Logger logger = LoggerFactory.getLogger(SpringAxonAutoConfigurer.class);
    private ConfigurableListableBeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition("commandHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(CommandHandlerSubscriber.class).getBeanDefinition());
        Configurer configurer = DefaultConfigurer.defaultConfiguration();
        RuntimeBeanReference parameterResolver = SpringContextParameterResolverFactoryBuilder.getBeanReference(registry);
        configurer.registerComponent(ParameterResolverFactory.class, c -> (ParameterResolverFactory)this.beanFactory.getBean(parameterResolver.getBeanName(), ParameterResolverFactory.class));
        this.findComponent(CommandBus.class).ifPresent(commandBus -> configurer.configureCommandBus(c -> (CommandBus)this.getBean((String)commandBus, (Configuration)c)));
        this.findComponent(EventStorageEngine.class).ifPresent(ese -> configurer.configureEmbeddedEventStore(c -> (EventStorageEngine)this.getBean((String)ese, (Configuration)c)));
        this.findComponent(EventBus.class).ifPresent(eventBus -> configurer.configureEventBus(c -> (EventBus)this.getBean((String)eventBus, (Configuration)c)));
        this.findComponent(Serializer.class).ifPresent(serializer -> configurer.configureSerializer(c -> (Serializer)this.getBean((String)serializer, (Configuration)c)));
        this.findComponent(TokenStore.class).ifPresent(tokenStore -> configurer.registerComponent(TokenStore.class, c -> (TokenStore)this.getBean((String)tokenStore, (Configuration)c)));
        try {
            this.findComponent(PlatformTransactionManager.class).ifPresent(ptm -> configurer.configureTransactionManager(c -> new SpringTransactionManager((PlatformTransactionManager)this.getBean((String)ptm, (Configuration)c))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.findComponent(TransactionManager.class).ifPresent(tm -> configurer.configureTransactionManager(c -> (TransactionManager)this.getBean((String)tm, (Configuration)c)));
        this.findComponent(SagaStore.class).ifPresent(sagaStore -> configurer.registerComponent(SagaStore.class, c -> (SagaStore)this.getBean((String)sagaStore, (Configuration)c)));
        String resourceInjector = this.findComponent(ResourceInjector.class, registry, () -> BeanDefinitionBuilder.genericBeanDefinition(SpringResourceInjector.class).getBeanDefinition());
        configurer.configureResourceInjector(c -> (ResourceInjector)this.getBean(resourceInjector, (Configuration)c));
        this.registerAggregateBeanDefinitions(configurer, registry);
        this.registerSagaBeanDefinitions(configurer);
        this.registerModules(configurer);
        Optional<String> eventHandlingConfiguration = this.findComponent(EventHandlingConfiguration.class);
        String ehConfigBeanName = eventHandlingConfiguration.orElse("eventHandlingConfiguration");
        if (!eventHandlingConfiguration.isPresent()) {
            registry.registerBeanDefinition(ehConfigBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventHandlingConfiguration.class).getBeanDefinition());
        }
        registry.registerBeanDefinition(AXON_CONFIGURATION_BEAN, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(AxonConfiguration.class).addConstructorArgValue((Object)configurer).getBeanDefinition());
        this.registerEventHandlerRegistrar(ehConfigBeanName, registry);
    }

    private <T> T getBean(String beanName, Configuration configuration) {
        return (T)((ApplicationContext)configuration.getComponent(ApplicationContext.class)).getBean(beanName);
    }

    private void registerEventHandlerRegistrar(String ehConfigBeanName, BeanDefinitionRegistry registry) {
        ManagedList beans = new ManagedList();
        this.beanFactory.getBeanNamesIterator().forEachRemaining(arg_0 -> this.lambda$registerEventHandlerRegistrar$21((List)beans, arg_0));
        registry.registerBeanDefinition("eventHandlerRegistrar", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventHandlerRegistrar.class).addConstructorArgReference(AXON_CONFIGURATION_BEAN).addConstructorArgReference(ehConfigBeanName).addPropertyValue("eventHandlers", (Object)beans).getBeanDefinition());
    }

    private String[] registerModules(Configurer configurer) {
        String[] modules;
        for (String module : modules = this.beanFactory.getBeanNamesForType(ModuleConfiguration.class)) {
            configurer.registerModule((ModuleConfiguration)new LazyRetrievedModuleConfiguration(() -> (ModuleConfiguration)this.beanFactory.getBean(module, ModuleConfiguration.class)));
        }
        return modules;
    }

    private void registerSagaBeanDefinitions(Configurer configurer) {
        String[] sagas;
        for (String saga : sagas = this.beanFactory.getBeanNamesForAnnotation(Saga.class)) {
            Saga sagaAnnotation = (Saga)this.beanFactory.findAnnotationOnBean(saga, Saga.class);
            SagaConfiguration sagaConfiguration = SagaConfiguration.subscribingSagaManager((Class)this.beanFactory.getType(saga));
            if (!"".equals(sagaAnnotation.sagaStore())) {
                sagaConfiguration.configureSagaStore(c -> (SagaStore)this.beanFactory.getBean(sagaAnnotation.sagaStore(), SagaStore.class));
            }
            configurer.registerModule((ModuleConfiguration)sagaConfiguration);
        }
    }

    private void registerAggregateBeanDefinitions(Configurer configurer, BeanDefinitionRegistry registry) {
        String[] aggregates;
        for (String aggregate : aggregates = this.beanFactory.getBeanNamesForAnnotation(Aggregate.class)) {
            Aggregate aggregateAnnotation = (Aggregate)this.beanFactory.findAnnotationOnBean(aggregate, Aggregate.class);
            AggregateConfigurer aggregateConf = AggregateConfigurer.defaultConfiguration((Class)this.beanFactory.getType(aggregate));
            if ("".equals(aggregateAnnotation.repository())) {
                String repositoryName = aggregate.substring(0, 1).toLowerCase() + aggregate.substring(1) + "Repository";
                String factoryName = aggregate.substring(0, 1).toLowerCase() + aggregate.substring(1) + "AggregateFactory";
                if (this.beanFactory.containsBean(repositoryName)) {
                    aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(repositoryName, Repository.class));
                } else {
                    if (!registry.isBeanNameInUse(factoryName)) {
                        registry.registerBeanDefinition(factoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringPrototypeAggregateFactory.class).addPropertyValue("prototypeBeanName", (Object)aggregate).getBeanDefinition());
                    }
                    aggregateConf.configureAggregateFactory(c -> (AggregateFactory)this.beanFactory.getBean(factoryName, AggregateFactory.class));
                }
            } else {
                aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(aggregateAnnotation.repository(), Repository.class));
            }
            configurer.configureAggregate((AggregateConfiguration)aggregateConf);
        }
    }

    private <T> String findComponent(Class<T> componentType, BeanDefinitionRegistry registry, Supplier<BeanDefinition> defaultBean) {
        return this.findComponent(componentType).orElseGet(() -> {
            BeanDefinition beanDefinition = (BeanDefinition)defaultBean.get();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            registry.registerBeanDefinition(beanName, beanDefinition);
            return beanName;
        });
    }

    private <T> Optional<String> findComponent(Class<T> componentType) {
        String[] beans = this.beanFactory.getBeanNamesForType(componentType);
        if (beans.length == 1) {
            return Optional.of(beans[0]);
        }
        if (beans.length > 1) {
            for (String bean : beans) {
                BeanDefinition beanDef = this.beanFactory.getBeanDefinition(bean);
                if (!beanDef.isPrimary()) continue;
                return Optional.of(bean);
            }
            logger.warn("Multiple beans of type {} found in application context: {}. Chose {}", new Object[]{componentType.getSimpleName(), beans, beans[0]});
            return Optional.of(beans[0]);
        }
        return Optional.empty();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private /* synthetic */ void lambda$registerEventHandlerRegistrar$21(List beans, String bean) {
        boolean hasHandler;
        Class beanType;
        if (!this.beanFactory.isFactoryBean(bean) && (beanType = this.beanFactory.getType(bean)) != null && this.beanFactory.containsBeanDefinition(bean) && this.beanFactory.getBeanDefinition(bean).isSingleton() && (hasHandler = StreamSupport.stream(ReflectionUtils.methodsOf((Class)beanType).spliterator(), false).map(m -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class).orElse(null)).filter(Objects::nonNull).anyMatch(attr -> EventMessage.class.isAssignableFrom((Class)attr.get("messageType"))))) {
            beans.add(new RuntimeBeanReference(bean));
        }
    }

    private class LazyRetrievedModuleConfiguration
    implements ModuleConfiguration {
        private final Supplier<ModuleConfiguration> delegateSupplier;
        private ModuleConfiguration delegate;

        public LazyRetrievedModuleConfiguration(Supplier<ModuleConfiguration> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
        }

        public void initialize(Configuration config) {
            this.delegate = this.delegateSupplier.get();
            this.delegate.initialize(config);
        }

        public void start() {
            this.delegate.start();
        }

        public void shutdown() {
            this.delegate.shutdown();
        }
    }

    public static class ImportSelector
    implements DeferredImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{SpringAxonAutoConfigurer.class.getName()};
        }
    }
}

