/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.serialization.Serializer;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.CommandHandlerSubscriber;
import org.axonframework.spring.config.annotation.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.spring.eventsourcing.SpringPrototypeAggregateFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.axonframework.spring.stereotype.Aggregate;
import org.axonframework.spring.stereotype.Saga;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringAxonAutoConfigurer
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringAxonAutoConfigurer.class);
    private ConfigurableListableBeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition("commandHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(CommandHandlerSubscriber.class).getBeanDefinition());
        Configurer configurer = DefaultConfigurer.defaultConfiguration();
        RuntimeBeanReference parameterResolver = SpringContextParameterResolverFactoryBuilder.getBeanReference(registry);
        configurer.registerComponent(ParameterResolverFactory.class, c -> (ParameterResolverFactory)this.beanFactory.getBean(parameterResolver.getBeanName(), ParameterResolverFactory.class));
        this.findComponent(CommandBus.class).ifPresent(commandBus -> configurer.configureCommandBus(arg_0 -> SpringAxonAutoConfigurer.lambda$null$1((Supplier)commandBus, arg_0)));
        this.findComponent(EventStorageEngine.class).ifPresent(ese -> configurer.configureEmbeddedEventStore(arg_0 -> SpringAxonAutoConfigurer.lambda$null$3((Supplier)ese, arg_0)));
        this.findComponent(EventBus.class).ifPresent(eventBus -> configurer.configureEventBus(arg_0 -> SpringAxonAutoConfigurer.lambda$null$5((Supplier)eventBus, arg_0)));
        this.findComponent(Serializer.class).ifPresent(serializer -> configurer.configureSerializer(arg_0 -> SpringAxonAutoConfigurer.lambda$null$7((Supplier)serializer, arg_0)));
        this.findComponent(TokenStore.class).ifPresent(tokenStore -> configurer.registerComponent(TokenStore.class, arg_0 -> SpringAxonAutoConfigurer.lambda$null$9((Supplier)tokenStore, arg_0)));
        this.findComponent(PlatformTransactionManager.class).ifPresent(ptm -> configurer.configureTransactionManager(arg_0 -> SpringAxonAutoConfigurer.lambda$null$11((Supplier)ptm, arg_0)));
        this.findComponent(TransactionManager.class).ifPresent(tm -> configurer.configureTransactionManager(arg_0 -> SpringAxonAutoConfigurer.lambda$null$13((Supplier)tm, arg_0)));
        this.findComponent(SagaStore.class).ifPresent(sagaStore -> configurer.registerComponent(SagaStore.class, arg_0 -> SpringAxonAutoConfigurer.lambda$null$15((Supplier)sagaStore, arg_0)));
        this.registerAggregateBeanDefinitions(configurer, registry);
        this.registerSagaBeanDefinitions(configurer, registry);
        this.registerModules(configurer);
        if (!this.findComponent(EventHandlingConfiguration.class).isPresent()) {
            this.registerDefaultEventHandlerConfiguration(configurer);
        }
        registry.registerBeanDefinition("axonConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(AxonConfiguration.class).addConstructorArgValue((Object)configurer.buildConfiguration()).getBeanDefinition());
    }

    private void registerDefaultEventHandlerConfiguration(Configurer configurer) {
        EventHandlingConfiguration eventHandlingConfiguration = EventHandlingConfiguration.assigningHandlersByPackage();
        this.beanFactory.getBeanNamesIterator().forEachRemaining(bean -> {
            boolean hasHandler;
            Class beanType = this.beanFactory.getType(bean);
            if (this.beanFactory.containsBeanDefinition(bean) && this.beanFactory.getBeanDefinition(bean).isSingleton() && (hasHandler = StreamSupport.stream(ReflectionUtils.methodsOf((Class)beanType).spliterator(), false).map(m -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class).orElse(null)).filter(Objects::nonNull).anyMatch(attr -> EventMessage.class.isAssignableFrom((Class)attr.get("messageType"))))) {
                eventHandlingConfiguration.registerEventHandler(c -> this.beanFactory.getBean(bean));
            }
        });
        configurer.registerModule((ModuleConfiguration)eventHandlingConfiguration);
    }

    private String[] registerModules(Configurer configurer) {
        String[] modules;
        for (String module : modules = this.beanFactory.getBeanNamesForType(ModuleConfiguration.class)) {
            configurer.registerModule((ModuleConfiguration)new LazyRetrievedModuleConfiguration(() -> (ModuleConfiguration)this.beanFactory.getBean(module, ModuleConfiguration.class)));
        }
        return modules;
    }

    private void registerSagaBeanDefinitions(Configurer configurer, BeanDefinitionRegistry registry) {
        String[] sagas;
        for (String saga : sagas = this.beanFactory.getBeanNamesForAnnotation(Saga.class)) {
            Saga sagaAnnotation = (Saga)this.beanFactory.findAnnotationOnBean(saga, Saga.class);
            SagaConfiguration sagaConfiguration = SagaConfiguration.subscribingSagaManager((Class)this.beanFactory.getType(saga));
            if (!"".equals(sagaAnnotation.sagaStore())) {
                sagaConfiguration.configureSagaStore(c -> (SagaStore)this.beanFactory.getBean(sagaAnnotation.sagaStore(), SagaStore.class));
            }
            configurer.registerModule((ModuleConfiguration)sagaConfiguration);
        }
    }

    private void registerAggregateBeanDefinitions(Configurer configurer, BeanDefinitionRegistry registry) {
        String[] aggregates;
        for (String aggregate : aggregates = this.beanFactory.getBeanNamesForAnnotation(Aggregate.class)) {
            Aggregate aggregateAnnotation = (Aggregate)this.beanFactory.findAnnotationOnBean(aggregate, Aggregate.class);
            AggregateConfigurer aggregateConf = AggregateConfigurer.defaultConfiguration((Class)this.beanFactory.getType(aggregate));
            if ("".equals(aggregateAnnotation.repository())) {
                String repositoryName = aggregate.substring(0, 1).toLowerCase() + aggregate.substring(1) + "Repository";
                String factoryName = aggregate.substring(0, 1).toLowerCase() + aggregate.substring(1) + "AggregateFactory";
                if (this.beanFactory.containsBean(repositoryName)) {
                    aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(repositoryName, Repository.class));
                } else {
                    if (!registry.isBeanNameInUse(factoryName)) {
                        registry.registerBeanDefinition(factoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringPrototypeAggregateFactory.class).addPropertyValue("prototypeBeanName", (Object)aggregate).getBeanDefinition());
                    }
                    aggregateConf.configureAggregateFactory(c -> (AggregateFactory)this.beanFactory.getBean(factoryName, AggregateFactory.class));
                }
            } else {
                aggregateConf.configureRepository(c -> (Repository)this.beanFactory.getBean(aggregateAnnotation.repository(), Repository.class));
            }
            configurer.configureAggregate((AggregateConfiguration)aggregateConf);
        }
    }

    private <T> Optional<Supplier<T>> findComponent(Class<T> commandBusClass) {
        String[] beans = this.beanFactory.getBeanNamesForType(commandBusClass);
        if (beans.length == 1) {
            return Optional.of(() -> this.beanFactory.getBean(beans[0], commandBusClass));
        }
        if (beans.length > 1) {
            for (String bean : beans) {
                BeanDefinition beanDef = this.beanFactory.getBeanDefinition(bean);
                if (!beanDef.isPrimary()) continue;
                return Optional.of(() -> this.beanFactory.getBean(bean, commandBusClass));
            }
            logger.warn("Multiple beans of type {} found in application context: {}. Chose {}", new Object[]{commandBusClass.getSimpleName(), beans, beans[0]});
            return Optional.of(() -> this.beanFactory.getBean(beans[0], commandBusClass));
        }
        return Optional.empty();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private static /* synthetic */ SagaStore lambda$null$15(Supplier sagaStore, Configuration c) {
        return (SagaStore)sagaStore.get();
    }

    private static /* synthetic */ TransactionManager lambda$null$13(Supplier tm, Configuration c) {
        return (TransactionManager)tm.get();
    }

    private static /* synthetic */ TransactionManager lambda$null$11(Supplier ptm, Configuration c) {
        return new SpringTransactionManager((PlatformTransactionManager)ptm.get());
    }

    private static /* synthetic */ TokenStore lambda$null$9(Supplier tokenStore, Configuration c) {
        return (TokenStore)tokenStore.get();
    }

    private static /* synthetic */ Serializer lambda$null$7(Supplier serializer, Configuration c) {
        return (Serializer)serializer.get();
    }

    private static /* synthetic */ EventBus lambda$null$5(Supplier eventBus, Configuration c) {
        return (EventBus)eventBus.get();
    }

    private static /* synthetic */ EventStorageEngine lambda$null$3(Supplier ese, Configuration c) {
        return (EventStorageEngine)ese.get();
    }

    private static /* synthetic */ CommandBus lambda$null$1(Supplier commandBus, Configuration c) {
        return (CommandBus)commandBus.get();
    }

    private class LazyRetrievedModuleConfiguration
    implements ModuleConfiguration {
        private final Supplier<ModuleConfiguration> delegateSupplier;
        private ModuleConfiguration delegate;

        public LazyRetrievedModuleConfiguration(Supplier<ModuleConfiguration> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
        }

        public void initialize(Configuration config) {
            this.delegate = this.delegateSupplier.get();
            this.delegate.initialize(config);
        }

        public void start() {
            this.delegate.start();
        }

        public void shutdown() {
            this.delegate.shutdown();
        }
    }

    public static class ImportSelector
    implements DeferredImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{SpringAxonAutoConfigurer.class.getName()};
        }
    }
}

