/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.config.Configuration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.spring.config.NoBeanOfType;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
public class AxonConfiguration
implements Configuration {
    private final Configuration config;

    public AxonConfiguration(Configuration config) {
        this.config = config;
    }

    @NoBeanOfType(value=CommandBus.class)
    @Bean
    public CommandBus commandBus() {
        return this.config.commandBus();
    }

    @NoBeanOfType(value=EventBus.class)
    @Bean
    public EventBus eventBus() {
        return this.config.eventBus();
    }

    @Bean
    public ConfigurationLifecycle configurationLifecycle() {
        return new ConfigurationLifecycle();
    }

    public <T> Repository<T> repository(Class<T> aggregate) {
        return this.config.repository(aggregate);
    }

    public <T> T getComponent(Class<T> componentType, Supplier<T> defaultImpl) {
        return (T)this.config.getComponent(componentType, defaultImpl);
    }

    public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> componentType, String componentName) {
        return this.config.messageMonitor(componentType, componentName);
    }

    public void start() {
        this.config.start();
    }

    public void shutdown() {
        this.config.shutdown();
    }

    public List<CorrelationDataProvider> correlationDataProviders() {
        return this.config.correlationDataProviders();
    }

    public class ConfigurationLifecycle
    implements SmartLifecycle {
        private volatile boolean running = false;

        public void start() {
            AxonConfiguration.this.config.start();
            this.running = true;
        }

        public void stop() {
            AxonConfiguration.this.shutdown();
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(Runnable callback) {
            this.stop();
            callback.run();
        }

        public int getPhase() {
            return 0;
        }
    }
}

