/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.eventhandling.AnnotationEventListenerAdapter;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.config.AbstractAnnotationHandlerBeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class AnnotationEventListenerBeanPostProcessor
extends AbstractAnnotationHandlerBeanPostProcessor<EventListener, AnnotationEventListenerAdapter> {
    @Override
    protected Class<?>[] getAdapterInterfaces() {
        return new Class[]{EventListener.class};
    }

    @Override
    protected AnnotationEventListenerAdapter initializeAdapterFor(Object bean, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotationEventListenerAdapter(bean, parameterResolverFactory);
    }

    @Override
    protected boolean isPostProcessingCandidate(Class<?> targetClass) {
        return this.isNotEventHandlerSubclass(targetClass) && this.hasEventHandlerMethod(targetClass);
    }

    private boolean isNotEventHandlerSubclass(Class<?> beanClass) {
        return !EventListener.class.isAssignableFrom(beanClass);
    }

    private boolean hasEventHandlerMethod(Class<?> beanClass) {
        AtomicBoolean result = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new HasEventHandlerAnnotationMethodCallback(result));
        return result.get();
    }

    private static final class HasEventHandlerAnnotationMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final AtomicBoolean result;

        private HasEventHandlerAnnotationMethodCallback(AtomicBoolean result) {
            this.result = result;
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            if (method.isAnnotationPresent(EventHandler.class)) {
                this.result.set(true);
            }
        }
    }
}

