/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging.adapter;

import java.util.Map;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.spring.messaging.adapter.EventFilter;
import org.axonframework.spring.messaging.adapter.NoFilter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

public class EventPublishingMessageChannelAdapter
implements MessageHandler {
    private final EventFilter filter;
    private final EventBus eventBus;

    public EventPublishingMessageChannelAdapter(EventBus eventBus) {
        this.eventBus = eventBus;
        this.filter = new NoFilter();
    }

    public EventPublishingMessageChannelAdapter(EventBus eventBus, EventFilter filter) {
        this.eventBus = eventBus;
        this.filter = filter;
    }

    public void handleMessage(Message<?> message) {
        Class<?> eventType = message.getPayload().getClass();
        if (this.filter.accept(eventType)) {
            this.eventBus.publish(new EventMessage[]{new GenericEventMessage(message.getPayload(), (Map)message.getHeaders())});
        }
    }
}

