/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling.java;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.java.SimpleEventScheduler;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SimpleEventSchedulerFactoryBean
implements FactoryBean<SimpleEventScheduler>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private EventBus eventBus;
    private ScheduledExecutorService executorService;
    private ScheduledExecutorService executorServiceToShutDown;
    private SimpleEventScheduler eventScheduler;
    private ApplicationContext applicationContext;
    private PlatformTransactionManager transactionManager;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();

    public SimpleEventScheduler getObject() throws Exception {
        return this.eventScheduler;
    }

    public Class<?> getObjectType() {
        return SimpleEventScheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executorService == null) {
            this.executorServiceToShutDown = this.executorService = Executors.newSingleThreadScheduledExecutor();
        }
        if (this.eventBus == null) {
            this.eventBus = (EventBus)this.applicationContext.getBean(EventBus.class);
        }
        this.eventScheduler = this.transactionManager == null ? new SimpleEventScheduler(this.executorService, this.eventBus) : new SimpleEventScheduler(this.executorService, this.eventBus, (UnitOfWorkFactory)new DefaultUnitOfWorkFactory((TransactionManager)new SpringTransactionManager(this.transactionManager, this.transactionDefinition)));
    }

    public void destroy() throws Exception {
        if (this.executorServiceToShutDown != null) {
            this.executorServiceToShutDown.shutdown();
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

