/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging.adapter;

import java.util.Map;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.spring.messaging.adapter.EventFilter;
import org.axonframework.spring.messaging.adapter.NoFilter;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.GenericMessage;

public class EventListeningMessageChannelAdapter
implements EventListener,
InitializingBean,
BeanNameAware {
    private final MessageChannel channel;
    private final EventFilter filter;
    private final EventBus eventBus;
    private String beanName;

    public EventListeningMessageChannelAdapter(EventBus eventBus, MessageChannel channel) {
        this.eventBus = eventBus;
        this.channel = channel;
        this.filter = new NoFilter();
    }

    public EventListeningMessageChannelAdapter(EventBus eventBus, MessageChannel channel, EventFilter filter) {
        this.channel = channel;
        this.eventBus = eventBus;
        this.filter = filter;
    }

    public void afterPropertiesSet() {
        new SubscribingEventProcessor((EventHandlerInvoker)new SimpleEventHandlerInvoker(this.beanName, new Object[]{this}), this.eventBus).start();
    }

    public void handle(EventMessage event) {
        if (this.filter.accept(event.getPayload().getClass())) {
            this.channel.send((Message)new GenericMessage(event.getPayload(), (Map)event.getMetaData()));
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }
}

