/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.Map;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Priority(value=-1073741824)
public class SpringBeanParameterResolverFactory
implements ParameterResolverFactory,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanParameterResolverFactory.class);
    private ApplicationContext applicationContext;

    public SpringBeanParameterResolverFactory() {
    }

    public SpringBeanParameterResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (this.applicationContext == null) {
            return null;
        }
        Class<?> parameterType = parameters[parameterIndex].getType();
        Map beansFound = this.applicationContext.getBeansOfType(parameterType);
        if (beansFound.isEmpty()) {
            return null;
        }
        if (beansFound.size() > 1) {
            AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                Iterator iterator = beansFound.entrySet().iterator();
                while (iterator.hasNext()) {
                    ConfigurableListableBeanFactory clBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
                    Map.Entry bean = iterator.next();
                    if (!clBeanFactory.containsBeanDefinition((String)bean.getKey()) || !clBeanFactory.getBeanDefinition((String)bean.getKey()).isPrimary()) continue;
                    return new SpringBeanParameterResolver(beanFactory, (String)bean.getKey());
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn("{} beans of type {} found, but none was marked as primary. Ignoring this parameter.", (Object)beansFound.size(), (Object)parameterType.getSimpleName());
            }
            return null;
        }
        return new SpringBeanParameterResolver(this.applicationContext.getAutowireCapableBeanFactory(), (String)beansFound.keySet().iterator().next());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class SpringBeanParameterResolver
    implements ParameterResolver<Object> {
        private final AutowireCapableBeanFactory beanFactory;
        private final String beanName;

        public SpringBeanParameterResolver(AutowireCapableBeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.beanName = beanName;
        }

        public Object resolveParameterValue(Message message) {
            return this.beanFactory.getBean(this.beanName);
        }

        public boolean matches(Message message) {
            return true;
        }
    }
}

