/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import io.axoniq.axonserver.connector.event.PersistentStreamProperties;
import io.axoniq.axonserver.connector.impl.ObjectUtils;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceDefinition;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceFactory;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamScheduledExecutorBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class PersistentStreamMessageSourceRegistrar
implements BeanDefinitionRegistryPostProcessor {
    private final Map<String, AxonServerConfiguration.PersistentStreamSettings> persistentStreams;
    private final PersistentStreamScheduledExecutorBuilder executorBuilder;

    public PersistentStreamMessageSourceRegistrar(Environment environment, PersistentStreamScheduledExecutorBuilder executorBuilder) {
        Binder binder = Binder.get((Environment)environment);
        this.persistentStreams = (Map)binder.bind("axon.axonserver.persistent-streams", Bindable.mapOf(String.class, AxonServerConfiguration.PersistentStreamSettings.class)).orElse(Collections.emptyMap());
        this.executorBuilder = executorBuilder;
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.persistentStreams.forEach((name, settings) -> {
            BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(PersistentStreamMessageSourceDefinition.class);
            String streamName = (String)ObjectUtils.nonNullOrDefault((Object)settings.getName(), (Object)name);
            beanDefinition.addConstructorArgValue((Object)streamName);
            BeanDefinitionBuilder streamProperties = BeanDefinitionBuilder.genericBeanDefinition(PersistentStreamProperties.class);
            streamProperties.addConstructorArgValue((Object)streamName);
            streamProperties.addConstructorArgValue((Object)settings.getInitialSegmentCount());
            streamProperties.addConstructorArgValue((Object)settings.getSequencingPolicy());
            streamProperties.addConstructorArgValue((Object)settings.getSequencingPolicyParameters());
            streamProperties.addConstructorArgValue((Object)settings.getInitialPosition());
            streamProperties.addConstructorArgValue((Object)settings.getFilter());
            beanDefinition.addConstructorArgValue((Object)streamProperties.getBeanDefinition());
            beanDefinition.addConstructorArgValue((Object)this.executorBuilder.build(Integer.valueOf(settings.getThreadCount()), streamName));
            beanDefinition.addConstructorArgValue((Object)settings.getBatchSize());
            beanDefinition.addConstructorArgValue(null);
            beanDefinition.addConstructorArgValue((Object)new RuntimeBeanReference(PersistentStreamMessageSourceFactory.class));
            beanDefinitionRegistry.registerBeanDefinition(name, (BeanDefinition)beanDefinition.getBeanDefinition());
        });
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }
}

