/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.axonframework.micrometer.GlobalMetricRegistry;
import org.axonframework.micrometer.MetricsConfigurerModule;
import org.axonframework.springboot.MetricsProperties;
import org.axonframework.springboot.autoconfig.LegacyAxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration"})
@AutoConfigureBefore(value={LegacyAxonAutoConfiguration.class, MetricsAutoConfiguration.class})
@ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry", "org.axonframework.micrometer.GlobalMetricRegistry"})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class MicrometerMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public static MeterRegistry meterRegistry() {
        return new SimpleMeterRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={GlobalMetricRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    public static GlobalMetricRegistry globalMetricRegistry(MeterRegistry meterRegistry) {
        return new GlobalMetricRegistry(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={MetricsConfigurerModule.class})
    @ConditionalOnBean(value={GlobalMetricRegistry.class})
    @ConditionalOnProperty(value={"axon.metrics.auto-configuration.enabled"}, matchIfMissing=true)
    public static MetricsConfigurerModule metricsConfigurerModule(GlobalMetricRegistry globalMetricRegistry, MetricsProperties metricsProperties) {
        return new MetricsConfigurerModule(globalMetricRegistry, metricsProperties.getMicrometer().isDimensional());
    }
}

