/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.thoughtworks.xstream.XStream;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.apache.avro.message.SchemaStore;
import org.axonframework.axonserver.connector.TagsConfiguration;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.InterceptingCommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.SnapshotterSpanFactory;
import org.axonframework.eventsourcing.eventstore.LegacyEmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.LegacyEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.ProcessingLifecycleHandlerRegistrar;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryBusSpanFactory;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.QueryUpdateEmitterSpanFactory;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.avro.AvroSerializer;
import org.axonframework.serialization.avro.AvroSerializerStrategy;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.springboot.DistributedCommandBusProperties;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.SerializerProperties;
import org.axonframework.springboot.TagsConfigurationProperties;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@AutoConfigureAfter(value={EventProcessingAutoConfiguration.class})
@EnableConfigurationProperties(value={EventProcessorProperties.class, DistributedCommandBusProperties.class, SerializerProperties.class, TagsConfigurationProperties.class})
public class LegacyAxonAutoConfiguration
implements BeanClassLoaderAware {
    private final EventProcessorProperties eventProcessorProperties;
    private final SerializerProperties serializerProperties;
    private final TagsConfigurationProperties tagsConfigurationProperties;
    private final ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;

    public LegacyAxonAutoConfiguration(EventProcessorProperties eventProcessorProperties, SerializerProperties serializerProperties, TagsConfigurationProperties tagsConfigurationProperties, ApplicationContext applicationContext) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.serializerProperties = serializerProperties;
        this.tagsConfigurationProperties = tagsConfigurationProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    public TagsConfiguration tagsConfiguration() {
        return this.tagsConfigurationProperties.toTagsConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    public RevisionResolver revisionResolver() {
        return new AnnotationRevisionResolver();
    }

    @Bean
    @Primary
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="!eventSerializer,messageSerializer")
    public Serializer serializer(RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.AVRO.equals((Object)this.serializerProperties.getGeneral())) {
            throw new AxonConfigurationException(String.format("Invalid serializer type [%s] configured as general serializer. The Avro Serializer can be used as message or event serializer only.", this.serializerProperties.getGeneral().name()));
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getGeneral(), null);
    }

    @Bean
    @Qualifier(value="messageSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="messageSerializer")
    public Serializer messageSerializer(Serializer generalSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getMessages()) || this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getMessages())) {
            return generalSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getMessages(), generalSerializer);
    }

    @Bean
    @Qualifier(value="eventSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="eventSerializer")
    public Serializer eventSerializer(@Qualifier(value="messageSerializer") Serializer messageSerializer, Serializer generalSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getEvents()) || this.serializerProperties.getEvents().equals((Object)this.serializerProperties.getMessages())) {
            return messageSerializer;
        }
        if (this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getEvents())) {
            return generalSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getEvents(), generalSerializer);
    }

    @Bean
    public ConfigurerModule serializerConfigurer(@Qualifier(value="eventSerializer") Serializer eventSerializer, @Qualifier(value="messageSerializer") Serializer messageSerializer, Serializer generalSerializer) {
        return configurer -> {
            configurer.configureEventSerializer(c -> eventSerializer);
            configurer.configureMessageSerializer(c -> messageSerializer);
            configurer.configureSerializer(c -> generalSerializer);
        };
    }

    private Serializer buildSerializer(RevisionResolver revisionResolver, SerializerProperties.SerializerType serializerType, Serializer generalSerializer) {
        switch (serializerType) {
            case AVRO: {
                SchemaStore schemaStore;
                Map schemaStoreBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, SchemaStore.class);
                SchemaStore schemaStore2 = schemaStore = schemaStoreBeans.containsKey("defaultAxonSchemaStore") ? (SchemaStore)schemaStoreBeans.get("defaultAxonSchemaStore") : (SchemaStore)schemaStoreBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(SchemaStore.class));
                if (generalSerializer == null) {
                    throw new AxonConfigurationException("General serializer is mandatory as a fallback Avro Serializer, but none was provided.");
                }
                Map serializationStrategies = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, AvroSerializerStrategy.class);
                AvroSerializer.Builder builder = AvroSerializer.builder().schemaStore(schemaStore).serializerDelegate(generalSerializer).revisionResolver(revisionResolver);
                serializationStrategies.values().forEach(arg_0 -> ((AvroSerializer.Builder)builder).addSerializerStrategy(arg_0));
                return builder.build();
            }
            case JACKSON: {
                Map objectMapperBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
                ObjectMapper objectMapper = objectMapperBeans.containsKey("defaultAxonObjectMapper") ? (ObjectMapper)objectMapperBeans.get("defaultAxonObjectMapper") : (ObjectMapper)objectMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(ObjectMapper.class));
                ChainingConverter converter = new ChainingConverter(this.beanClassLoader);
                return JacksonSerializer.builder().revisionResolver(revisionResolver).converter((Converter)converter).objectMapper(objectMapper).build();
            }
            case CBOR: {
                Map cborMapperBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, CBORMapper.class);
                ObjectMapper cborMapper = cborMapperBeans.containsKey("defaultAxonCborObjectMapper") ? (ObjectMapper)cborMapperBeans.get("defaultAxonCborObjectMapper") : (ObjectMapper)cborMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(CBORMapper.class));
                ChainingConverter cborConverter = new ChainingConverter(this.beanClassLoader);
                return JacksonSerializer.builder().revisionResolver(revisionResolver).converter((Converter)cborConverter).objectMapper(cborMapper).build();
            }
        }
        Map xStreamBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, XStream.class);
        XStream xStream = xStreamBeans.containsKey("defaultAxonXStream") ? (XStream)xStreamBeans.get("defaultAxonXStream") : (XStream)xStreamBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(XStream.class));
        return XStreamSerializer.builder().xStream(xStream).revisionResolver(revisionResolver).classLoader(this.beanClassLoader).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CorrelationDataProvider messageOriginProvider() {
        return new MessageOriginProvider();
    }

    @Qualifier(value="eventStore")
    @Bean(name={"eventBus"})
    @ConditionalOnMissingBean(value={EventBus.class})
    @ConditionalOnBean(value={LegacyEventStorageEngine.class})
    public LegacyEmbeddedEventStore eventStore(LegacyEventStorageEngine storageEngine, LegacyConfiguration configuration) {
        return LegacyEmbeddedEventStore.builder().storageEngine(storageEngine).messageMonitor(configuration.messageMonitor(LegacyEventStore.class, "eventStore")).spanFactory((EventBusSpanFactory)configuration.getComponent(EventBusSpanFactory.class)).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public CommandGateway commandGateway(CommandBus commandBus) {
        return new DefaultCommandGateway(commandBus, (MessageTypeResolver)new ClassBasedMessageTypeResolver());
    }

    @ConditionalOnMissingBean
    @Bean
    public QueryGateway queryGateway(QueryBus queryBus) {
        return DefaultQueryGateway.builder().queryBus(queryBus).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={LegacyEventStorageEngine.class, EventBus.class})
    public SimpleEventBus eventBus(LegacyConfiguration configuration) {
        return SimpleEventBus.builder().messageMonitor(configuration.messageMonitor(LegacyEventStore.class, "eventStore")).spanFactory((EventBusSpanFactory)configuration.getComponent(EventBusSpanFactory.class)).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public EventSink eventSink(EventBus eventBus) {
        return (context, events) -> {
            eventBus.publish(events);
            return FutureUtils.emptyCompletedFuture();
        };
    }

    @ConditionalOnMissingBean
    @Bean
    public MessageTypeResolver messageTypeResolver() {
        return new ClassBasedMessageTypeResolver();
    }

    @ConditionalOnMissingBean
    @Bean
    public EventGateway eventGateway(EventSink eventSink, MessageTypeResolver messageTypeResolver) {
        return new DefaultEventGateway(eventSink, messageTypeResolver);
    }

    @ConditionalOnMissingBean(value={Snapshotter.class})
    @ConditionalOnBean(value={LegacyEventStore.class})
    @Bean
    public SpringAggregateSnapshotter aggregateSnapshotter(LegacyConfiguration configuration, HandlerDefinition handlerDefinition, ParameterResolverFactory parameterResolverFactory, LegacyEventStore eventStore, TransactionManager transactionManager, SnapshotterSpanFactory spanFactory) {
        return SpringAggregateSnapshotter.builder().repositoryProvider(arg_0 -> ((LegacyConfiguration)configuration).repository(arg_0)).transactionManager(transactionManager).eventStore(eventStore).parameterResolverFactory(parameterResolverFactory).handlerDefinition(handlerDefinition).spanFactory(spanFactory).build();
    }

    @Autowired
    public void configureEventHandling(EventProcessingConfigurer eventProcessingConfigurer, ApplicationContext applicationContext) {
        this.eventProcessorProperties.getProcessors().forEach((name, settings) -> {
            Function<LegacyConfiguration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy = this.resolveSequencingPolicy(applicationContext, (EventProcessorProperties.ProcessorSettings)settings);
            eventProcessingConfigurer.registerSequencingPolicy(name, sequencingPolicy);
            if (settings.getMode() == EventProcessorProperties.Mode.POOLED) {
                eventProcessingConfigurer.registerPooledStreamingEventProcessor(name, this.resolveMessageSource(applicationContext, (EventProcessorProperties.ProcessorSettings)settings), (config, builder) -> {
                    ScheduledExecutorService workerExecutor = Executors.newScheduledThreadPool(settings.getThreadCount(), (ThreadFactory)new AxonThreadFactory("WorkPackage[" + name + "]"));
                    config.onShutdown(workerExecutor::shutdown);
                    return builder.workerExecutor(workerExecutor).initialSegmentCount(this.initialSegmentCount((EventProcessorProperties.ProcessorSettings)settings, 16)).tokenClaimInterval(this.tokenClaimIntervalMillis((EventProcessorProperties.ProcessorSettings)settings)).batchSize(settings.getBatchSize());
                });
            } else if (settings.getSource() == null) {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name);
            } else {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name, c -> {
                    Object bean = applicationContext.getBean(settings.getSource());
                    if (bean instanceof SubscribableMessageSource) {
                        return (SubscribableMessageSource)bean;
                    }
                    throw new AxonConfigurationException(String.format("Invalid message source [%s] configured for Event Processor [%s]. The message source should be a SubscribableMessageSource or SubscribableMessageSourceFactory", settings.getSource(), name));
                });
            }
            if (settings.getDlq().getCache().isEnabled()) {
                eventProcessingConfigurer.registerDeadLetteringEventHandlerInvokerConfiguration(name, (c, builder) -> builder.enableSequenceIdentifierCache().sequenceIdentifierCacheSize(settings.getDlq().getCache().getSize()));
            }
        });
    }

    private int initialSegmentCount(EventProcessorProperties.ProcessorSettings settings, int defaultCount) {
        return settings.getInitialSegmentCount() != null ? settings.getInitialSegmentCount() : defaultCount;
    }

    private long tokenClaimIntervalMillis(EventProcessorProperties.ProcessorSettings settings) {
        return settings.getTokenClaimIntervalTimeUnit().toMillis(settings.getTokenClaimInterval());
    }

    private Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> resolveMessageSource(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<LegacyConfiguration, Object> messageSource = v.getSource() == null ? LegacyConfiguration::eventStore : c -> (StreamableMessageSource)applicationContext.getBean(v.getSource(), StreamableMessageSource.class);
        return messageSource;
    }

    private Function<LegacyConfiguration, SequencingPolicy<? super EventMessage<?>>> resolveSequencingPolicy(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<LegacyConfiguration, Object> sequencingPolicy = v.getSequencingPolicy() != null ? c -> (SequencingPolicy)applicationContext.getBean(v.getSequencingPolicy(), SequencingPolicy.class) : c -> SequentialPerAggregatePolicy.instance();
        return sequencingPolicy;
    }

    @ConditionalOnMissingBean(ignoredType={"org.axonframework.commandhandling.distributed.DistributedCommandBus", "org.axonframework.extensions.multitenancy.components.commandhandeling.MultiTenantCommandBus"}, value={CommandBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public CommandBus commandBus(TransactionManager txManager, LegacyConfiguration axonConfiguration) {
        SimpleCommandBus commandBus = new SimpleCommandBus(new ProcessingLifecycleHandlerRegistrar[]{txManager});
        return new InterceptingCommandBus((CommandBus)commandBus, List.of(new CorrelationDataInterceptor((Collection)axonConfiguration.correlationDataProviders())), Collections.emptyList());
    }

    @ConditionalOnMissingBean(value={QueryBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleQueryBus queryBus(LegacyConfiguration axonConfiguration, TransactionManager transactionManager) {
        return SimpleQueryBus.builder().messageMonitor(axonConfiguration.messageMonitor(QueryBus.class, "queryBus")).transactionManager(transactionManager).errorHandler((QueryInvocationErrorHandler)axonConfiguration.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter((QueryUpdateEmitter)axonConfiguration.getComponent(QueryUpdateEmitter.class)).spanFactory((QueryBusSpanFactory)axonConfiguration.getComponent(QueryBusSpanFactory.class)).build();
    }

    @Bean
    public QueryUpdateEmitter queryUpdateEmitter(LegacyConfiguration configuration) {
        return SimpleQueryUpdateEmitter.builder().updateMessageMonitor(configuration.messageMonitor(QueryUpdateEmitter.class, "queryUpdateEmitter")).spanFactory((QueryUpdateEmitterSpanFactory)configuration.getComponent(QueryUpdateEmitterSpanFactory.class)).build();
    }

    public void setBeanClassLoader(@Nonnull ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

