/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.command.CommandLoadFactorProvider;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventScheduler;
import org.axonframework.axonserver.connector.event.axon.EventProcessorInfoConfiguration;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.TagsConfigurationProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.service.connection.AxonServerConnectionDetails;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@AutoConfiguration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
@ConditionalOnClass(value={AxonServerConfiguration.class})
@EnableConfigurationProperties(value={TagsConfigurationProperties.class})
@ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
public class AxonServerAutoConfiguration {
    private static String clientName(@Nullable String id) {
        if (id == null) {
            return "Unnamed";
        }
        if (id.contains(":")) {
            return id.substring(0, id.indexOf(":"));
        }
        return id;
    }

    @Bean
    @ConditionalOnMissingBean
    public ManagedChannelCustomizer managedChannelCustomizer() {
        return ManagedChannelCustomizer.identity();
    }

    @Bean
    public AxonServerConnectionManager platformConnectionManager(AxonServerConfiguration axonServerConfiguration, TagsConfigurationProperties tagsConfigurationProperties, ManagedChannelCustomizer managedChannelCustomizer) {
        return AxonServerConnectionManager.builder().axonServerConfiguration(axonServerConfiguration).tagsConfiguration(tagsConfigurationProperties.toTagsConfiguration()).channelCustomizer((UnaryOperator)managedChannelCustomizer).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RoutingStrategy routingStrategy() {
        return AnnotationRoutingStrategy.defaultStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandPriorityCalculator commandPriorityCalculator() {
        return CommandPriorityCalculator.defaultCommandPriorityCalculator();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandLoadFactorProvider commandLoadFactorProvider(AxonServerConfiguration configuration) {
        return command -> configuration.getCommandLoadFactor();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryPriorityCalculator queryPriorityCalculator() {
        return QueryPriorityCalculator.defaultQueryPriorityCalculator();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryInvocationErrorHandler queryInvocationErrorHandler() {
        return LoggingQueryInvocationErrorHandler.builder().build();
    }

    @ConditionalOnMissingBean
    @Bean
    public TargetContextResolver<Message<?>> targetContextResolver() {
        return TargetContextResolver.noOp();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.axonframework.extensions.multitenancy.autoconfig.MultiTenancyAxonServerAutoConfiguration"})
    public EventProcessorInfoConfiguration processorInfoConfiguration(EventProcessingConfiguration eventProcessingConfiguration, AxonServerConnectionManager connectionManager, AxonServerConfiguration configuration) {
        return new EventProcessorInfoConfiguration(c -> eventProcessingConfiguration, c -> connectionManager, c -> configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public EventScheduler eventScheduler(@Qualifier(value="eventSerializer") Serializer eventSerializer, AxonServerConnectionManager connectionManager) {
        return AxonServerEventScheduler.builder().eventSerializer(eventSerializer).connectionManager(connectionManager).build();
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.autoconfigure.service.connection.ConnectionDetails"})
    public static class ConnectionDetailsConfiguration
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        @ConditionalOnMissingBean(value={AxonServerConnectionDetails.class})
        @Bean
        public AxonServerConfiguration axonServerConfiguration() {
            AxonServerConfiguration configuration = new AxonServerConfiguration();
            configuration.setComponentName(AxonServerAutoConfiguration.clientName(this.applicationContext.getId()));
            return configuration;
        }

        @ConditionalOnBean(type={"org.axonframework.springboot.service.connection.AxonServerConnectionDetails"})
        @Bean
        public AxonServerConfiguration axonServerConfigurationWithConnectionDetails(AxonServerConnectionDetails connectionDetails) {
            AxonServerConfiguration configuration = new AxonServerConfiguration();
            configuration.setComponentName(AxonServerAutoConfiguration.clientName(this.applicationContext.getId()));
            configuration.setServers(connectionDetails.routingServers());
            return configuration;
        }

        public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.boot.autoconfigure.service.connection.ConnectionDetails"})
    public static class ConnectionConfiguration
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        @Bean
        public AxonServerConfiguration axonServerConfiguration() {
            AxonServerConfiguration configuration = new AxonServerConfiguration();
            configuration.setComponentName(AxonServerAutoConfiguration.clientName(this.applicationContext.getId()));
            return configuration;
        }

        public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}

