/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.springboot.SerializerProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.util.XStreamSecurityTypeUtility;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
@ConditionalOnClass(name={"com.thoughtworks.xstream.XStream"})
@EnableConfigurationProperties(value={SerializerProperties.class})
public class XStreamAutoConfiguration {
    @Bean(value={"defaultAxonXStream"})
    @ConditionalOnMissingBean
    @Conditional(value={XStreamConfiguredCondition.class})
    public XStream defaultAxonXStream(ApplicationContext applicationContext) {
        XStream xStream = new XStream((HierarchicalStreamDriver)new CompactDriver());
        XStreamSecurityTypeUtility.allowTypesFromComponentScanAnnotatedBeans(applicationContext, xStream);
        return xStream;
    }

    private static class XStreamConfiguredCondition
    extends AnyNestedCondition {
        public XStreamConfiguredCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"axon.serializer.events"}, havingValue="xstream")
        static class EventsXStreamCondition {
            EventsXStreamCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.serializer.messages"}, havingValue="xstream")
        static class MessagesXStreamCondition {
            MessagesXStreamCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.serializer.general"}, havingValue="xstream", matchIfMissing=true)
        static class GeneralXStreamCondition {
            GeneralXStreamCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.serializer.general"}, havingValue="default", matchIfMissing=true)
        static class GeneralDefaultCondition {
            GeneralDefaultCondition() {
            }
        }
    }
}

