/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="axon.eventhandling")
public class EventProcessorProperties {
    private final Map<String, ProcessorSettings> processors = new HashMap<String, ProcessorSettings>();

    public Map<String, ProcessorSettings> getProcessors() {
        return this.processors;
    }

    public static class ProcessorSettings {
        private String source;
        private Mode mode = Mode.SUBSCRIBING;
        private int initialSegmentCount = 1;
        private int threadCount = -1;
        private int batchSize = 1;
        private String sequencingPolicy;

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public int getInitialSegmentCount() {
            return this.initialSegmentCount;
        }

        public void setInitialSegmentCount(int initialSegmentCount) {
            this.initialSegmentCount = initialSegmentCount;
        }

        public int getThreadCount() {
            return this.threadCount < 0 ? this.initialSegmentCount : this.threadCount;
        }

        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public String getSequencingPolicy() {
            return this.sequencingPolicy;
        }

        public void setSequencingPolicy(String sequencingPolicy) {
            this.sequencingPolicy = sequencingPolicy;
        }
    }

    public static enum Mode {
        TRACKING,
        SUBSCRIBING;

    }
}

