/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import org.axonframework.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.amqp.eventhandling.DefaultAMQPMessageConverter;
import org.axonframework.amqp.eventhandling.PackageRoutingKeyResolver;
import org.axonframework.amqp.eventhandling.RoutingKeyResolver;
import org.axonframework.amqp.eventhandling.spring.SpringAMQPPublisher;
import org.axonframework.boot.AMQPProperties;
import org.axonframework.boot.autoconfig.AxonAutoConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.serialization.Serializer;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SpringAMQPPublisher.class})
@EnableConfigurationProperties(value={AMQPProperties.class})
@AutoConfigureAfter(value={RabbitAutoConfiguration.class, AxonAutoConfiguration.class})
public class AMQPAutoConfiguration {
    @Autowired
    private AMQPProperties amqpProperties;

    @ConditionalOnMissingBean
    @Bean
    public RoutingKeyResolver routingKeyResolver() {
        return new PackageRoutingKeyResolver();
    }

    @ConditionalOnMissingBean
    @Bean
    public AMQPMessageConverter amqpMessageConverter(@Qualifier(value="eventSerializer") Serializer eventSerializer, RoutingKeyResolver routingKeyResolver) {
        return new DefaultAMQPMessageConverter(eventSerializer, routingKeyResolver, this.amqpProperties.isDurableMessages());
    }

    @ConditionalOnProperty(value={"axon.amqp.exchange"})
    @ConditionalOnBean(value={ConnectionFactory.class})
    @ConditionalOnMissingBean
    @Bean(initMethod="start", destroyMethod="shutDown")
    public SpringAMQPPublisher amqpBridge(EventBus eventBus, ConnectionFactory connectionFactory, AMQPMessageConverter amqpMessageConverter) {
        SpringAMQPPublisher publisher = new SpringAMQPPublisher((SubscribableMessageSource)eventBus);
        publisher.setExchangeName(this.amqpProperties.getExchange());
        publisher.setConnectionFactory(connectionFactory);
        publisher.setMessageConverter(amqpMessageConverter);
        switch (this.amqpProperties.getTransactionMode()) {
            case TRANSACTIONAL: {
                publisher.setTransactional(true);
                break;
            }
            case PUBLISHER_ACK: {
                publisher.setWaitForPublisherAck(true);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transaction mode: " + (Object)((Object)this.amqpProperties.getTransactionMode()));
            }
        }
        return publisher;
    }
}

