/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import org.axonframework.boot.DistributedCommandBusProperties;
import org.axonframework.boot.autoconfig.JGroupsAutoConfiguration;
import org.axonframework.boot.autoconfig.RoutingStrategyAutoConfiguration;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.serialization.Serializer;
import org.axonframework.springcloud.commandhandling.SpringCloudCommandRouter;
import org.axonframework.springcloud.commandhandling.SpringCloudHttpBackupCommandRouter;
import org.axonframework.springcloud.commandhandling.SpringHttpCommandBusConnector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={RoutingStrategyAutoConfiguration.class, NoopDiscoveryClientAutoConfiguration.class, SimpleDiscoveryClientAutoConfiguration.class})
@AutoConfigureBefore(value={JGroupsAutoConfiguration.class})
@ConditionalOnProperty(value={"axon.distributed.enabled"})
@ConditionalOnClass(name={"org.axonframework.springcloud.commandhandling.SpringCloudCommandRouter", "org.axonframework.springcloud.commandhandling.SpringCloudHttpBackupCommandRouter", "org.axonframework.springcloud.commandhandling.SpringHttpCommandBusConnector", "org.springframework.cloud.client.discovery.DiscoveryClient", "org.springframework.web.client.RestTemplate"})
public class SpringCloudAutoConfiguration {
    @Autowired
    private DistributedCommandBusProperties properties;

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={CommandRouter.class})
    @ConditionalOnBean(value={DiscoveryClient.class})
    @ConditionalOnProperty(value={"axon.distributed.spring-cloud.fallback-to-http-get"}, matchIfMissing=true)
    public SpringCloudHttpBackupCommandRouter springCloudHttpBackupCommandRouter(DiscoveryClient discoveryClient, Registration localServiceInstance, RestTemplate restTemplate, RoutingStrategy routingStrategy) {
        return new SpringCloudHttpBackupCommandRouter(discoveryClient, localServiceInstance, routingStrategy, restTemplate, this.properties.getSpringCloud().getFallbackUrl());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DiscoveryClient.class})
    public CommandRouter springCloudCommandRouter(DiscoveryClient discoveryClient, Registration localServiceInstance, RoutingStrategy routingStrategy) {
        return new SpringCloudCommandRouter(discoveryClient, localServiceInstance, routingStrategy);
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandBusConnector.class})
    public SpringHttpCommandBusConnector springHttpCommandBusConnector(@Qualifier(value="localSegment") CommandBus localSegment, RestTemplate restTemplate, @Qualifier(value="messageSerializer") Serializer serializer) {
        return new SpringHttpCommandBusConnector(localSegment, (RestOperations)restTemplate, serializer);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

