/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import com.codahale.metrics.MetricRegistry;
import org.axonframework.boot.MetricsProperties;
import org.axonframework.boot.autoconfig.AxonAutoConfiguration;
import org.axonframework.metrics.GlobalMetricRegistry;
import org.axonframework.metrics.MetricsConfigurerModule;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
@ConditionalOnClass(name={"com.codahale.metrics.MetricRegistry", "org.axonframework.metrics.GlobalMetricRegistry"})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MetricRegistry.class})
    public GlobalMetricRegistry globalMetricRegistry(MetricRegistry metricRegistry) {
        return new GlobalMetricRegistry(metricRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={GlobalMetricRegistry.class})
    @ConditionalOnProperty(value={"axon.metrics.auto-configuration.enabled"}, matchIfMissing=true)
    public MetricsConfigurerModule metricsConfigurerModule(GlobalMetricRegistry globalMetricRegistry) {
        return new MetricsConfigurerModule(globalMetricRegistry);
    }
}

